/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactbirthday_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactbirthday.h>
#include <qcontactdetail.h>
#include <qdatetime.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactBirthday_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactBirthday >()))
        return -1;

    QtMobility::QContactBirthday* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactBirthday", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactBirthday(QtMobility::QContactBirthday)
    // 1: QContactBirthday()
    // 2: QContactBirthday(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactBirthday()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactBirthday(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactBirthday & >::isConvertible(arg)) {
        overloadId = 0; // QContactBirthday(QtMobility::QContactBirthday)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactBirthday_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactBirthday(QtMobility::QContactBirthday)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactBirthday > cpp_arg0_auto_ptr;
                QtMobility::QContactBirthday* cpp_arg0 = Shiboken::Converter<QtMobility::QContactBirthday* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactBirthday >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactBirthday >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactBirthday(QtMobility::QContactBirthday)
                cptr = new QtMobility::QContactBirthday(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactBirthday()
            {

                if(!PyErr_Occurred()) {
                // QContactBirthday()
                cptr = new QtMobility::QContactBirthday();
                }
                break;
            }
            case 2: // QContactBirthday(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactBirthday(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactBirthday(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactBirthday >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactBirthday_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactBirthday_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactBirthday", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactBirthday", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactBirthdayFunc_date(PyObject* self)
{
    QtMobility::QContactBirthday* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactBirthday* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // date()const
            QDate cppResult = cppSelf->QtMobility::QContactBirthday::date();
            pyResult = Shiboken::Converter<QDate >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactBirthdayFunc_setDate(PyObject* self, PyObject* arg)
{
    QtMobility::QContactBirthday* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactBirthday* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setDate(QDate)
    if (Shiboken::Converter<const QDate & >::isConvertible(arg)) {
        overloadId = 0; // setDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactBirthdayFunc_setDate_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QDate* cpp_arg0 = Shiboken::Converter<QDate* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setDate(QDate)
            cppSelf->QtMobility::QContactBirthday::setDate(*cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactBirthdayFunc_setDate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactBirthday.setDate", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactBirthday_methods[] = {
    {"date", (PyCFunction)SbkQtMobility_QContactBirthdayFunc_date, METH_NOARGS},
    {"setDate", (PyCFunction)SbkQtMobility_QContactBirthdayFunc_setDate, METH_O},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactBirthday_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactBirthday",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactBirthday_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactBirthday_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactBirthday >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactBirthday",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactBirthday(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTBIRTHDAY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactBirthday_Type);

    SbkQtMobility_QContactBirthday_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactBirthday_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactBirthday_Type));
    PyModule_AddObject(module, "QContactBirthday",
        ((PyObject*)&SbkQtMobility_QContactBirthday_Type));

    PyDict_SetItemString(SbkQtMobility_QContactBirthday_Type.super.ht_type.tp_dict, "FieldBirthday", Shiboken::Converter<QString >::toPython(QtMobility::QContactBirthday::FieldBirthday));
    PyDict_SetItemString(SbkQtMobility_QContactBirthday_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactBirthday::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactBirthday >("QtMobility::QContactBirthday");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactBirthday >("QtMobility::QContactBirthday*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactBirthday >(typeid(QtMobility::QContactBirthday).name());
    PySide::initQtMetaType<QtMobility::QContactBirthday >();
}

