/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactaddress_wrapper.h"

// Extra includes
#include <QMap>
#include <QStringList>
#include <qcontactaddress.h>
#include <qcontactdetail.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QContactAddress_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QContactAddress >()))
        return -1;

    QtMobility::QContactAddress* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QContactAddress", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QContactAddress(QtMobility::QContactAddress)
    // 1: QContactAddress()
    // 2: QContactAddress(QtMobility::QContactDetail)
    if (numArgs == 0) {
        overloadId = 1; // QContactAddress()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactDetail & >::isConvertible(arg)) {
        overloadId = 2; // QContactAddress(QtMobility::QContactDetail)
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QContactAddress & >::isConvertible(arg)) {
        overloadId = 0; // QContactAddress(QtMobility::QContactAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddress_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QContactAddress(QtMobility::QContactAddress)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                std::auto_ptr<QtMobility::QContactAddress > cpp_arg0_auto_ptr;
                QtMobility::QContactAddress* cpp_arg0 = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(arg);
                if (!Shiboken::Converter<QtMobility::QContactAddress >::checkType(arg))
                    cpp_arg0_auto_ptr = std::auto_ptr<QtMobility::QContactAddress >(cpp_arg0);

                if(!PyErr_Occurred()) {
                // QContactAddress(QtMobility::QContactAddress)
                cptr = new QtMobility::QContactAddress(*cpp_arg0);
                }
                break;
            }
            case 1: // QContactAddress()
            {

                if(!PyErr_Occurred()) {
                // QContactAddress()
                cptr = new QtMobility::QContactAddress();
                }
                break;
            }
            case 2: // QContactAddress(QtMobility::QContactDetail)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QContactDetail* cpp_arg0 = Shiboken::Converter<QtMobility::QContactDetail* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QContactAddress(QtMobility::QContactDetail)
                cptr = new QtMobility::QContactAddress(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QContactAddress >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QContactAddress_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QContactAddress_Init_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactAddress", "", "QtMobility.Contacts.QtMobility::QContactDetail", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Contacts.QContactAddress", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QContactAddressFunc_country(PyObject* self)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // country()const
            QString cppResult = cppSelf->QtMobility::QContactAddress::country();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAddressFunc_locality(PyObject* self)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // locality()const
            QString cppResult = cppSelf->QtMobility::QContactAddress::locality();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAddressFunc_postOfficeBox(PyObject* self)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // postOfficeBox()const
            QString cppResult = cppSelf->QtMobility::QContactAddress::postOfficeBox();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAddressFunc_postcode(PyObject* self)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // postcode()const
            QString cppResult = cppSelf->QtMobility::QContactAddress::postcode();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAddressFunc_region(PyObject* self)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // region()const
            QString cppResult = cppSelf->QtMobility::QContactAddress::region();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAddressFunc_setCountry(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setCountry(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setCountry(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddressFunc_setCountry_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setCountry(QString)
            cppSelf->QtMobility::QContactAddress::setCountry(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAddressFunc_setCountry_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAddress.setCountry", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAddressFunc_setLocality(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setLocality(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setLocality(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddressFunc_setLocality_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setLocality(QString)
            cppSelf->QtMobility::QContactAddress::setLocality(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAddressFunc_setLocality_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAddress.setLocality", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAddressFunc_setPostOfficeBox(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPostOfficeBox(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setPostOfficeBox(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddressFunc_setPostOfficeBox_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPostOfficeBox(QString)
            cppSelf->QtMobility::QContactAddress::setPostOfficeBox(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAddressFunc_setPostOfficeBox_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAddress.setPostOfficeBox", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAddressFunc_setPostcode(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setPostcode(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setPostcode(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddressFunc_setPostcode_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setPostcode(QString)
            cppSelf->QtMobility::QContactAddress::setPostcode(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAddressFunc_setPostcode_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAddress.setPostcode", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAddressFunc_setRegion(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setRegion(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setRegion(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddressFunc_setRegion_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setRegion(QString)
            cppSelf->QtMobility::QContactAddress::setRegion(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAddressFunc_setRegion_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAddress.setRegion", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAddressFunc_setStreet(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setStreet(QString)
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setStreet(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddressFunc_setStreet_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setStreet(QString)
            cppSelf->QtMobility::QContactAddress::setStreet(cpp_arg0);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAddressFunc_setStreet_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAddress.setStreet", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAddressFunc_setSubTypes(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setSubTypes(QString)
    // 1: setSubTypes(QStringList)
    if (Shiboken::Converter< QStringList  >::isConvertible(arg)) {
        overloadId = 1; // setSubTypes(QStringList)
    } else if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // setSubTypes(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAddressFunc_setSubTypes_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // setSubTypes(QString)
            {
                QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setSubTypes(QString)
                cppSelf->QtMobility::QContactAddress::setSubTypes(cpp_arg0);
                }
                break;
            }
            case 1: // setSubTypes(QStringList)
            {
                QStringList cpp_arg0 = Shiboken::Converter<QStringList >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // setSubTypes(QStringList)
                cppSelf->QtMobility::QContactAddress::setSubTypes(cpp_arg0);
                }
                break;
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAddressFunc_setSubTypes_TypeError:
        const char* overloads[] = {"QString", "list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAddress.setSubTypes", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAddressFunc_street(PyObject* self)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // street()const
            QString cppResult = cppSelf->QtMobility::QContactAddress::street();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAddressFunc_subTypes(PyObject* self)
{
    QtMobility::QContactAddress* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAddress* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // subTypes()const
            QStringList cppResult = cppSelf->QtMobility::QContactAddress::subTypes();
            pyResult = Shiboken::Converter<QStringList >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QContactAddress_methods[] = {
    {"country", (PyCFunction)SbkQtMobility_QContactAddressFunc_country, METH_NOARGS},
    {"locality", (PyCFunction)SbkQtMobility_QContactAddressFunc_locality, METH_NOARGS},
    {"postOfficeBox", (PyCFunction)SbkQtMobility_QContactAddressFunc_postOfficeBox, METH_NOARGS},
    {"postcode", (PyCFunction)SbkQtMobility_QContactAddressFunc_postcode, METH_NOARGS},
    {"region", (PyCFunction)SbkQtMobility_QContactAddressFunc_region, METH_NOARGS},
    {"setCountry", (PyCFunction)SbkQtMobility_QContactAddressFunc_setCountry, METH_O},
    {"setLocality", (PyCFunction)SbkQtMobility_QContactAddressFunc_setLocality, METH_O},
    {"setPostOfficeBox", (PyCFunction)SbkQtMobility_QContactAddressFunc_setPostOfficeBox, METH_O},
    {"setPostcode", (PyCFunction)SbkQtMobility_QContactAddressFunc_setPostcode, METH_O},
    {"setRegion", (PyCFunction)SbkQtMobility_QContactAddressFunc_setRegion, METH_O},
    {"setStreet", (PyCFunction)SbkQtMobility_QContactAddressFunc_setStreet, METH_O},
    {"setSubTypes", (PyCFunction)SbkQtMobility_QContactAddressFunc_setSubTypes, METH_O},
    {"street", (PyCFunction)SbkQtMobility_QContactAddressFunc_street, METH_NOARGS},
    {"subTypes", (PyCFunction)SbkQtMobility_QContactAddressFunc_subTypes, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactAddress_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactAddress",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactAddress_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QContactAddress_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactAddress >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactAddress",
    /*user_data*/           0
};
} //extern


void init_QtMobility_QContactAddress(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTADDRESS_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactAddress_Type);

    SbkQtMobility_QContactAddress_Type.super.ht_type.tp_base = SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTDETAIL_IDX];
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactAddress_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactAddress_Type));
    PyModule_AddObject(module, "QContactAddress",
        ((PyObject*)&SbkQtMobility_QContactAddress_Type));

    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "FieldStreet", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::FieldStreet));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "FieldPostOfficeBox", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::FieldPostOfficeBox));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "FieldPostcode", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::FieldPostcode));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "FieldSubTypes", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::FieldSubTypes));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "SubTypeParcel", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::SubTypeParcel));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "FieldRegion", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::FieldRegion));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "FieldLocality", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::FieldLocality));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "FieldCountry", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::FieldCountry));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "SubTypeInternational", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::SubTypeInternational));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "SubTypePostal", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::SubTypePostal));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "SubTypeDomestic", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::SubTypeDomestic));
    PyDict_SetItemString(SbkQtMobility_QContactAddress_Type.super.ht_type.tp_dict, "DefinitionName", Shiboken::Converter<QString >::toPython(QtMobility::QContactAddress::DefinitionName));

    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactAddress >("QtMobility::QContactAddress");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactAddress >("QtMobility::QContactAddress*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactAddress >(typeid(QtMobility::QContactAddress).name());
    PySide::initQtMetaType<QtMobility::QContactAddress >();
}

