/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_contacts_python.h"

#include "qtmobility_qcontactabstractrequest_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcontactabstractrequest.h>
#include <qcontactmanager.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

void QContactAbstractRequestWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QContactAbstractRequestWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QContactAbstractRequestWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QContactAbstractRequestWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QContactAbstractRequestWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactAbstractRequest.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QContactAbstractRequestWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QContactAbstractRequest.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QContactAbstractRequestWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QContactAbstractRequestWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QContactAbstractRequest::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QContactAbstractRequestWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QContactAbstractRequest::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QContactAbstractRequestWrapper::~QContactAbstractRequestWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject* SbkQtMobility_QContactAbstractRequestFunc_cancel(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // cancel()
            bool cppResult = cppSelf->QtMobility::QContactAbstractRequest::cancel();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_error(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // error()const
            QtMobility::QContactManager::Error cppResult = cppSelf->QtMobility::QContactAbstractRequest::error();
            pyResult = Shiboken::Converter<QtMobility::QContactManager::Error >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_isActive(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = cppSelf->QtMobility::QContactAbstractRequest::isActive();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_isCanceled(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isCanceled()const
            bool cppResult = cppSelf->QtMobility::QContactAbstractRequest::isCanceled();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_isFinished(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = cppSelf->QtMobility::QContactAbstractRequest::isFinished();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_isInactive(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isInactive()const
            bool cppResult = cppSelf->QtMobility::QContactAbstractRequest::isInactive();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_manager(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // manager()const
            QtMobility::QContactManager * cppResult = cppSelf->QtMobility::QContactAbstractRequest::manager();
            pyResult = Shiboken::Converter<QtMobility::QContactManager * >::toPython(cppResult);
            Shiboken::setParent(self, pyResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_setManager(PyObject* self, PyObject* arg)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    int overloadId = -1;

    // Overloaded function decisor
    // 0: setManager(QtMobility::QContactManager*)
    if (Shiboken::Converter<QtMobility::QContactManager * >::isConvertible(arg)) {
        overloadId = 0; // setManager(QtMobility::QContactManager*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAbstractRequestFunc_setManager_TypeError;

    // Call function/method
    {
        {
            if (Shiboken::cppObjectIsInvalid(arg))
                return 0;
            QtMobility::QContactManager* cpp_arg0 = Shiboken::Converter<QtMobility::QContactManager* >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // setManager(QtMobility::QContactManager*)
            cppSelf->QtMobility::QContactAbstractRequest::setManager(cpp_arg0);
            Shiboken::setParent(self, arg);
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQtMobility_QContactAbstractRequestFunc_setManager_TypeError:
        const char* overloads[] = {"QtMobility.Contacts.QtMobility::QContactManager", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAbstractRequest.setManager", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_start(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // start()
            bool cppResult = cppSelf->QtMobility::QContactAbstractRequest::start();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_state(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // state()const
            QtMobility::QContactAbstractRequest::State cppResult = cppSelf->QtMobility::QContactAbstractRequest::state();
            pyResult = Shiboken::Converter<QtMobility::QContactAbstractRequest::State >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_type(PyObject* self)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QtMobility::QContactAbstractRequest::RequestType cppResult = cppSelf->QtMobility::QContactAbstractRequest::type();
            pyResult = Shiboken::Converter<QtMobility::QContactAbstractRequest::RequestType >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QContactAbstractRequestFunc_waitForFinished(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QContactAbstractRequest* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QContactAbstractRequest* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "msecs" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactAbstractRequest.waitForFinished(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Contacts.QContactAbstractRequest.waitForFinished(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForFinished", &arg))
        return 0;


    // Overloaded function decisor
    // 0: waitForFinished(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForFinished(int)
    } else if (SbkNumber_Check(arg)) {
        overloadId = 0; // waitForFinished(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QContactAbstractRequestFunc_waitForFinished_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "msecs");
                if (value) {
                    if (arg)
                        errorArgName = "msecs";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Contacts.QContactAbstractRequest.waitForFinished(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            int cpp_arg0 = arg ? Shiboken::Converter<int >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // waitForFinished(int)
            bool cppResult = cppSelf->QtMobility::QContactAbstractRequest::waitForFinished(cpp_arg0);
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QContactAbstractRequestFunc_waitForFinished_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Contacts.QContactAbstractRequest.waitForFinished", overloads);
        return 0;
}

static PyMethodDef SbkQtMobility_QContactAbstractRequest_methods[] = {
    {"cancel", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_cancel, METH_NOARGS},
    {"error", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_error, METH_NOARGS},
    {"isActive", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_isActive, METH_NOARGS},
    {"isCanceled", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_isCanceled, METH_NOARGS},
    {"isFinished", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_isFinished, METH_NOARGS},
    {"isInactive", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_isInactive, METH_NOARGS},
    {"manager", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_manager, METH_NOARGS},
    {"setManager", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_setManager, METH_O},
    {"start", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_start, METH_NOARGS},
    {"state", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_state, METH_NOARGS},
    {"type", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_type, METH_NOARGS},
    {"waitForFinished", (PyCFunction)SbkQtMobility_QContactAbstractRequestFunc_waitForFinished, METH_VARARGS|METH_KEYWORDS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QContactAbstractRequest_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Contacts.QContactAbstractRequest",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QContactAbstractRequest_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              0,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QContactAbstractRequest >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QContactAbstractRequest*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QContactAbstractRequest_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QContactAbstractRequest*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QContactAbstractRequest_Type;
    return 0;
}

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RequestType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "State",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


void init_QtMobility_QContactAbstractRequest(PyObject* module)
{
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QContactAbstractRequest_Type);

    SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QContactAbstractRequest_Type.type_discovery = &SbkQtMobility_QContactAbstractRequest_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QContactAbstractRequest_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QContactAbstractRequest_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtMobility_QContactAbstractRequest_Type));
    PyModule_AddObject(module, "QContactAbstractRequest",
        ((PyObject*)&SbkQtMobility_QContactAbstractRequest_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RequestType
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_REQUESTTYPE_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type);
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
            "RequestType",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::InvalidRequest, "InvalidRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "InvalidRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "InvalidRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::ContactFetchRequest, "ContactFetchRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "ContactFetchRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "ContactFetchRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::ContactLocalIdFetchRequest, "ContactLocalIdFetchRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "ContactLocalIdFetchRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "ContactLocalIdFetchRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::ContactRemoveRequest, "ContactRemoveRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "ContactRemoveRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "ContactRemoveRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::ContactSaveRequest, "ContactSaveRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "ContactSaveRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "ContactSaveRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::DetailDefinitionFetchRequest, "DetailDefinitionFetchRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "DetailDefinitionFetchRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "DetailDefinitionFetchRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::DetailDefinitionRemoveRequest, "DetailDefinitionRemoveRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "DetailDefinitionRemoveRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "DetailDefinitionRemoveRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::DetailDefinitionSaveRequest, "DetailDefinitionSaveRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "DetailDefinitionSaveRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "DetailDefinitionSaveRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::RelationshipFetchRequest, "RelationshipFetchRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "RelationshipFetchRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "RelationshipFetchRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::RelationshipRemoveRequest, "RelationshipRemoveRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "RelationshipRemoveRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "RelationshipRemoveRequest", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type,
        (long) QtMobility::QContactAbstractRequest::RelationshipSaveRequest, "RelationshipSaveRequest");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "RelationshipSaveRequest", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_RequestType_Type.tp_dict,
        "RelationshipSaveRequest", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactAbstractRequest::RequestType");

    // init enum class: State
    SbkQtMobility_ContactsTypes[SBK_QTMOBILITY_QCONTACTABSTRACTREQUEST_STATE_IDX] = &SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type);
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
            "State",((PyObject*)&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type,
        (long) QtMobility::QContactAbstractRequest::InactiveState, "InactiveState");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "InactiveState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type.tp_dict,
        "InactiveState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type,
        (long) QtMobility::QContactAbstractRequest::ActiveState, "ActiveState");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "ActiveState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type.tp_dict,
        "ActiveState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type,
        (long) QtMobility::QContactAbstractRequest::CanceledState, "CanceledState");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "CanceledState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type.tp_dict,
        "CanceledState", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type,
        (long) QtMobility::QContactAbstractRequest::FinishedState, "FinishedState");
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict,
        "FinishedState", enum_item);
    PyDict_SetItemString(SbkQtMobility_Contacts_QtMobility_QContactAbstractRequest_State_Type.tp_dict,
        "FinishedState", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QContactAbstractRequest::State");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("resultsAvailable", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict, "resultsAvailable", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("stateChanged", "QtMobility::QContactAbstractRequest::State", NULL);
    PyDict_SetItemString(SbkQtMobility_QContactAbstractRequest_Type.super.ht_type.tp_dict, "stateChanged", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactAbstractRequest >("QtMobility::QContactAbstractRequest*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactAbstractRequest >(typeid(QtMobility::QContactAbstractRequest).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QContactAbstractRequest >(typeid(QContactAbstractRequestWrapper).name());
    PySide::initQtMetaType<QtMobility::QContactAbstractRequest* >();
}

