/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include <Python.h>
#include <shiboken.h>
#include <algorithm>
#include "qtmobility_contacts_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef Contacts_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtMobility_QContactChangeSet(PyObject* module);
void init_QtMobility_QContactManagerEngineFactory(PyObject* module);
void init_QtMobility_QContactFetchHint(PyObject* module);
void init_QtMobility_QContactSortOrder(PyObject* module);
void init_QtMobility_QContact(PyObject* module);
void init_QtMobility_QContactId(PyObject* module);
void init_QtMobility_QContactFilter(PyObject* module);
void init_QtMobility_QContactRelationshipFilter(PyObject* module);
void init_QtMobility_QContactIntersectionFilter(PyObject* module);
void init_QtMobility_QContactLocalIdFilter(PyObject* module);
void init_QtMobility_QContactUnionFilter(PyObject* module);
void init_QtMobility_QContactDetailRangeFilter(PyObject* module);
void init_QtMobility_QContactDetailFilter(PyObject* module);
void init_QtMobility_QContactInvalidFilter(PyObject* module);
void init_QtMobility_QContactChangeLogFilter(PyObject* module);
void init_QtMobility_QContactRelationship(PyObject* module);
void init_QtMobility_QContactDetailDefinition(PyObject* module);
void init_QtMobility_QContactDetailFieldDefinition(PyObject* module);
void init_QtMobility_QContactDetail(PyObject* module);
void init_QtMobility_QContactUrl(PyObject* module);
void init_QtMobility_QContactTimestamp(PyObject* module);
void init_QtMobility_QContactThumbnail(PyObject* module);
void init_QtMobility_QContactTag(PyObject* module);
void init_QtMobility_QContactType(PyObject* module);
void init_QtMobility_QContactSyncTarget(PyObject* module);
void init_QtMobility_QContactRingtone(PyObject* module);
void init_QtMobility_QContactPhoneNumber(PyObject* module);
void init_QtMobility_QContactDisplayLabel(PyObject* module);
void init_QtMobility_QContactOrganization(PyObject* module);
void init_QtMobility_QContactOnlineAccount(PyObject* module);
void init_QtMobility_QContactNote(PyObject* module);
void init_QtMobility_QContactNickname(PyObject* module);
void init_QtMobility_QContactName(PyObject* module);
void init_QtMobility_QContactGuid(PyObject* module);
void init_QtMobility_QContactGlobalPresence(PyObject* module);
void init_QtMobility_QContactPresence(PyObject* module);
void init_QtMobility_QContactGeoLocation(PyObject* module);
void init_QtMobility_QContactGender(PyObject* module);
void init_QtMobility_QContactFamily(PyObject* module);
void init_QtMobility_QContactEmailAddress(PyObject* module);
void init_QtMobility_QContactBirthday(PyObject* module);
void init_QtMobility_QContactAvatar(PyObject* module);
void init_QtMobility_QContactAnniversary(PyObject* module);
void init_QtMobility_QContactAddress(PyObject* module);
void init_QtMobility_QContactManagerEngine(PyObject* module);
void init_QtMobility_QContactManager(PyObject* module);
void init_QtMobility_QContactAbstractRequest(PyObject* module);
void init_QtMobility_QContactSaveRequest(PyObject* module);
void init_QtMobility_QContactRemoveRequest(PyObject* module);
void init_QtMobility_QContactLocalIdFetchRequest(PyObject* module);
void init_QtMobility_QContactFetchRequest(PyObject* module);
void init_QtMobility_QContactRelationshipSaveRequest(PyObject* module);
void init_QtMobility_QContactRelationshipRemoveRequest(PyObject* module);
void init_QtMobility_QContactRelationshipFetchRequest(PyObject* module);
void init_QtMobility_QContactDetailDefinitionSaveRequest(PyObject* module);
void init_QtMobility_QContactDetailDefinitionRemoveRequest(PyObject* module);
void init_QtMobility_QContactDetailDefinitionFetchRequest(PyObject* module);

PyTypeObject** SbkQtMobility_ContactsTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

PyTypeObject** SbkPySide_QtGuiTypes;

// Module initialization ------------------------------------------------------------

#if defined _WIN32 || defined __CYGWIN__
    #define SBK_EXPORT_MODULE __declspec(dllexport)
#elif __GNUC__ >= 4
    #define SBK_EXPORT_MODULE __attribute__ ((visibility("default")))
#else
    #define SBK_EXPORT_MODULE
#endif

extern "C" SBK_EXPORT_MODULE void initContacts()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    if (!Shiboken::importModule("PySide.QtGui", &SbkPySide_QtGuiTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtGui");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("Contacts", Contacts_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_Contacts_IDX_COUNT];
    SbkQtMobility_ContactsTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QtMobility_QContactChangeSet(module);
    init_QtMobility_QContactManagerEngineFactory(module);
    init_QtMobility_QContactFetchHint(module);
    init_QtMobility_QContactSortOrder(module);
    init_QtMobility_QContact(module);
    init_QtMobility_QContactId(module);
    init_QtMobility_QContactFilter(module);
    init_QtMobility_QContactRelationshipFilter(module);
    init_QtMobility_QContactIntersectionFilter(module);
    init_QtMobility_QContactLocalIdFilter(module);
    init_QtMobility_QContactUnionFilter(module);
    init_QtMobility_QContactDetailRangeFilter(module);
    init_QtMobility_QContactDetailFilter(module);
    init_QtMobility_QContactInvalidFilter(module);
    init_QtMobility_QContactChangeLogFilter(module);
    init_QtMobility_QContactRelationship(module);
    init_QtMobility_QContactDetailDefinition(module);
    init_QtMobility_QContactDetailFieldDefinition(module);
    init_QtMobility_QContactDetail(module);
    init_QtMobility_QContactUrl(module);
    init_QtMobility_QContactTimestamp(module);
    init_QtMobility_QContactThumbnail(module);
    init_QtMobility_QContactTag(module);
    init_QtMobility_QContactType(module);
    init_QtMobility_QContactSyncTarget(module);
    init_QtMobility_QContactRingtone(module);
    init_QtMobility_QContactPhoneNumber(module);
    init_QtMobility_QContactDisplayLabel(module);
    init_QtMobility_QContactOrganization(module);
    init_QtMobility_QContactOnlineAccount(module);
    init_QtMobility_QContactNote(module);
    init_QtMobility_QContactNickname(module);
    init_QtMobility_QContactName(module);
    init_QtMobility_QContactGuid(module);
    init_QtMobility_QContactGlobalPresence(module);
    init_QtMobility_QContactPresence(module);
    init_QtMobility_QContactGeoLocation(module);
    init_QtMobility_QContactGender(module);
    init_QtMobility_QContactFamily(module);
    init_QtMobility_QContactEmailAddress(module);
    init_QtMobility_QContactBirthday(module);
    init_QtMobility_QContactAvatar(module);
    init_QtMobility_QContactAnniversary(module);
    init_QtMobility_QContactAddress(module);
    init_QtMobility_QContactManagerEngine(module);
    init_QtMobility_QContactManager(module);
    init_QtMobility_QContactAbstractRequest(module);
    init_QtMobility_QContactSaveRequest(module);
    init_QtMobility_QContactRemoveRequest(module);
    init_QtMobility_QContactLocalIdFetchRequest(module);
    init_QtMobility_QContactFetchRequest(module);
    init_QtMobility_QContactRelationshipSaveRequest(module);
    init_QtMobility_QContactRelationshipRemoveRequest(module);
    init_QtMobility_QContactRelationshipFetchRequest(module);
    init_QtMobility_QContactDetailDefinitionSaveRequest(module);
    init_QtMobility_QContactDetailDefinitionRemoveRequest(module);
    init_QtMobility_QContactDetailDefinitionFetchRequest(module);

    // Register primitive types on TypeResolver
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QContactLocalId >("QtMobility::QContactLocalId");
    Shiboken::TypeResolver::createValueTypeResolver<QList<QtMobility::QContactLocalId> >("QList<QtMobility::QContactLocalId>");

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module Contacts");
    }
}

