/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "qtmobility_bearer_python.h"

#include "qtmobility_qnetworkconfigurationmanager_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qnetworkconfiguration.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qthread.h>

using namespace Shiboken;
using namespace QtMobility;

// Native ---------------------------------------------------------

QNetworkConfigurationManagerWrapper::QNetworkConfigurationManagerWrapper(QObject * parent) : QtMobility::QNetworkConfigurationManager(parent), m_metaObject(0) {
    // ... middle
}

void QNetworkConfigurationManagerWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkConfigurationManagerWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

void QNetworkConfigurationManagerWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QNetworkConfigurationManagerWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<const char * >::toPython(signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
}

bool QNetworkConfigurationManagerWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNetworkConfigurationManager.event", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cppResult;
}

bool QNetworkConfigurationManagerWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(NN)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(pyResult);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QNetworkConfigurationManager.eventFilter", "bool", pyResult->ob_type->tp_name);
        return bool(0);
    }
    bool cppResult(Shiboken::Converter<bool >::toCpp(pyResult));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cppResult;
}

void QNetworkConfigurationManagerWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(N)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QNetworkConfigurationManagerWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        void *typeData = Shiboken::getTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf));
        if (!typeData) {
            m_metaObject = PySide::DynamicQMetaObject::createBasedOn(pySelf, pySelf->ob_type, &QtMobility::QNetworkConfigurationManager::staticMetaObject);
            Shiboken::setTypeUserData(reinterpret_cast<Shiboken::SbkBaseWrapper*>(pySelf), m_metaObject, PySide::deleteDynamicQMetaObject);
        } else {
            m_metaObject = reinterpret_cast<PySide::DynamicQMetaObject*>(typeData);
        }
    }
    return m_metaObject;
}

int QNetworkConfigurationManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QtMobility::QNetworkConfigurationManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QNetworkConfigurationManagerWrapper::~QNetworkConfigurationManagerWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QNetworkConfigurationManager_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QNetworkConfigurationManager >()))
        return -1;

    QNetworkConfigurationManagerWrapper* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "parent" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                propertyKeys.push_back(argName);
            }
        }
    }

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QNetworkConfigurationManager", &arg))
        return -1;

    // Overloaded function decisor
    // 0: QNetworkConfigurationManager(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkConfigurationManager(QObject*)
    } else if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        overloadId = 0; // QNetworkConfigurationManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkConfigurationManager_Init_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "parent");
                if (value) {
                    if (arg)
                        errorArgName = "parent";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Bearer.QNetworkConfigurationManager(): got multiple values for keyword argument '%s'", errorArgName);
                    return -1;
                }
            }
            if (Shiboken::cppObjectIsInvalid(arg))
                return -1;
            QObject* cpp_arg0 = arg ? Shiboken::Converter<QObject* >::toCpp(arg) : 0;

            if(!PyErr_Occurred()) {
            // QNetworkConfigurationManager(QObject*)
            cptr = new QNetworkConfigurationManagerWrapper(cpp_arg0);
            Shiboken::setParent(arg, self);
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QNetworkConfigurationManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QNetworkConfigurationManager_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);
    PySide::signalUpdateSource(self);
    cptr->metaObject();
    for (std::vector<PyObject*>::size_type i = 0; i < propertyKeys.size(); i++) {
        const char* propName = PyString_AS_STRING(propertyKeys[i]);
        const QMetaObject* mo = cptr->metaObject();
        if (mo->indexOfProperty(propName) != -1) {
            cptr->setProperty(propName, Shiboken::Converter<QVariant>::toCpp(PyDict_GetItem(kwds, propertyKeys[i])));
        } else {
            QString signalSignature = QString("%1()").arg(propName);
            if (mo->indexOfSignal(qPrintable(signalSignature)) != -1) {
                signalSignature = '2' + signalSignature;
                PySide::signal_connect(self, qPrintable(signalSignature), PyDict_GetItem(kwds, propertyKeys[i]));
            } else {
                delete cptr;
                PyErr_Format(PyExc_AttributeError, "'%s' is not a Qt property or a signal", propName);
                return -1;
            };
        }
    }


    return 1;

    SbkQtMobility_QNetworkConfigurationManager_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Bearer.QNetworkConfigurationManager", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QNetworkConfigurationManagerFunc_allConfigurations(PyObject* self, PyObject* args, PyObject* kwds)
{
    QtMobility::QNetworkConfigurationManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfigurationManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;
    std::vector<PyObject*> propertyKeys;

    // Check existence of named argument.
    if (kwds) {
        std::string argNames[] = { "flags" };
        PyObject* keys = PyDict_Keys(kwds);
        Shiboken::AutoDecRef auto_keys(keys);
        for (int i = 0; i < PyList_GET_SIZE(keys); ++i) {
            PyObject* argName = PyList_GET_ITEM(keys, i);
            if (!std::binary_search(argNames, argNames + 1, std::string(PyString_AS_STRING(argName)))) {
                PyErr_Format(PyExc_TypeError, "QtMobility.Bearer.QNetworkConfigurationManager.allConfigurations(): got an unexpected keyword argument '%s'", PyString_AS_STRING(argName));
                return 0;
            }
        }
    }
    int numNamedArgs = (kwds ? PyDict_Size(kwds) : 0);
    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths
    if (numArgs + numNamedArgs > 1) {
        PyErr_SetString(PyExc_TypeError, "QtMobility.Bearer.QNetworkConfigurationManager.allConfigurations(): too many arguments");
        return 0;
    }

    if (!PyArg_ParseTuple(args, "|O:allConfigurations", &arg))
        return 0;


    // Overloaded function decisor
    // 0: allConfigurations(QFlags<QtMobility::QNetworkConfiguration::StateFlag>)const
    if (numArgs == 0) {
        overloadId = 0; // allConfigurations(QFlags<QtMobility::QNetworkConfiguration::StateFlag>)const
    } else if (Shiboken::Converter<QFlags<QtMobility::QNetworkConfiguration::StateFlag> >::isConvertible(arg)) {
        overloadId = 0; // allConfigurations(QFlags<QtMobility::QNetworkConfiguration::StateFlag>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkConfigurationManagerFunc_allConfigurations_TypeError;

    // Call function/method
    {
        {
            if (kwds) {
                const char* errorArgName = 0;
                PyObject* value = PyDict_GetItemString(kwds, "flags");
                if (value) {
                    if (arg)
                        errorArgName = "flags";
                    else
                        arg = value;
                }
                if (errorArgName) {
                    PyErr_Format(PyExc_TypeError, "QtMobility.Bearer.QNetworkConfigurationManager.allConfigurations(): got multiple values for keyword argument '%s'", errorArgName);
                    return 0;
                }
            }
            QFlags<QtMobility::QNetworkConfiguration::StateFlag> cpp_arg0 = arg ? Shiboken::Converter<QFlags<QtMobility::QNetworkConfiguration::StateFlag> >::toCpp(arg) : QFlags<QtMobility::QNetworkConfiguration::StateFlag>(0);

            if(!PyErr_Occurred()) {
            // allConfigurations(QFlags<QtMobility::QNetworkConfiguration::StateFlag>)const
            QList<QtMobility::QNetworkConfiguration > cppResult = cppSelf->QtMobility::QNetworkConfigurationManager::allConfigurations(cpp_arg0);
            pyResult = Shiboken::Converter<QList<QtMobility::QNetworkConfiguration > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QNetworkConfigurationManagerFunc_allConfigurations_TypeError:
        const char* overloads[] = {"QtMobility.Bearer.QtMobility::QNetworkConfiguration.StateFlags = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Bearer.QNetworkConfigurationManager.allConfigurations", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNetworkConfigurationManagerFunc_capabilities(PyObject* self)
{
    QtMobility::QNetworkConfigurationManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfigurationManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // capabilities()const
            QFlags<QtMobility::QNetworkConfigurationManager::Capability> cppResult = cppSelf->QtMobility::QNetworkConfigurationManager::capabilities();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QNetworkConfigurationManager::Capability> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationManagerFunc_configurationFromIdentifier(PyObject* self, PyObject* arg)
{
    QtMobility::QNetworkConfigurationManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfigurationManager* >::toCpp(self);

    PyObject* pyResult = 0;
    int overloadId = -1;

    // Overloaded function decisor
    // 0: configurationFromIdentifier(QString)const
    if (Shiboken::Converter<QString >::isConvertible(arg)) {
        overloadId = 0; // configurationFromIdentifier(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkConfigurationManagerFunc_configurationFromIdentifier_TypeError;

    // Call function/method
    {
        {
            QString cpp_arg0 = Shiboken::Converter<QString >::toCpp(arg);

            if(!PyErr_Occurred()) {
            // configurationFromIdentifier(QString)const
            QtMobility::QNetworkConfiguration cppResult = cppSelf->QtMobility::QNetworkConfigurationManager::configurationFromIdentifier(cpp_arg0);
            pyResult = Shiboken::Converter<QtMobility::QNetworkConfiguration >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;

    SbkQtMobility_QNetworkConfigurationManagerFunc_configurationFromIdentifier_TypeError:
        const char* overloads[] = {"QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "QtMobility.Bearer.QNetworkConfigurationManager.configurationFromIdentifier", overloads);
        return 0;
}

static PyObject* SbkQtMobility_QNetworkConfigurationManagerFunc_defaultConfiguration(PyObject* self)
{
    QtMobility::QNetworkConfigurationManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfigurationManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // defaultConfiguration()const
            QtMobility::QNetworkConfiguration cppResult = cppSelf->QtMobility::QNetworkConfigurationManager::defaultConfiguration();
            pyResult = Shiboken::Converter<QtMobility::QNetworkConfiguration >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationManagerFunc_isOnline(PyObject* self)
{
    QtMobility::QNetworkConfigurationManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfigurationManager* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isOnline()const
            bool cppResult = cppSelf->QtMobility::QNetworkConfigurationManager::isOnline();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationManagerFunc_updateConfigurations(PyObject* self)
{
    QtMobility::QNetworkConfigurationManager* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfigurationManager* >::toCpp(self);


    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // updateConfigurations()
            cppSelf->QtMobility::QNetworkConfigurationManager::updateConfigurations();
            }
        }
        }

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQtMobility_QNetworkConfigurationManager_methods[] = {
    {"allConfigurations", (PyCFunction)SbkQtMobility_QNetworkConfigurationManagerFunc_allConfigurations, METH_VARARGS|METH_KEYWORDS},
    {"capabilities", (PyCFunction)SbkQtMobility_QNetworkConfigurationManagerFunc_capabilities, METH_NOARGS},
    {"configurationFromIdentifier", (PyCFunction)SbkQtMobility_QNetworkConfigurationManagerFunc_configurationFromIdentifier, METH_O},
    {"defaultConfiguration", (PyCFunction)SbkQtMobility_QNetworkConfigurationManagerFunc_defaultConfiguration, METH_NOARGS},
    {"isOnline", (PyCFunction)SbkQtMobility_QNetworkConfigurationManagerFunc_isOnline, METH_NOARGS},
    {"updateConfigurations", (PyCFunction)SbkQtMobility_QNetworkConfigurationManagerFunc_updateConfigurations, METH_NOARGS},
    {0} // Sentinel
};

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QNetworkConfigurationManager_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Bearer.QNetworkConfigurationManager",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QNetworkConfigurationManager_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QNetworkConfigurationManager_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QNetworkConfigurationManager >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QNetworkConfigurationManager*",
    /*user_data*/           0
};
} //extern

static SbkBaseWrapperType* SbkQtMobility_QNetworkConfigurationManager_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType == reinterpret_cast<Shiboken::SbkBaseWrapperType*>(Shiboken::SbkType<QObject >()) && dynamic_cast<QtMobility::QNetworkConfigurationManager*>(reinterpret_cast<QObject*>(cptr)))
        return &SbkQtMobility_QNetworkConfigurationManager_Type;
    return 0;
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities >::checkType(self) && Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QNetworkConfigurationManager::Capabilities >::toPython(
        Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities>::toCpp(self)
        & Shiboken::Converter< QtMobility::QNetworkConfigurationManager::Capabilities >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities >::checkType(self) && Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QNetworkConfigurationManager::Capabilities >::toPython(
        Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities>::toCpp(self)
        | Shiboken::Converter< QtMobility::QNetworkConfigurationManager::Capabilities >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities >::checkType(self) && Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QNetworkConfigurationManager::Capabilities >::toPython(
        Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QNetworkConfigurationManager::Capabilities >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QNetworkConfigurationManager::Capabilities >::toPython(
        ~Shiboken::Converter<QtMobility::QNetworkConfigurationManager::Capabilities >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Capability",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capabilities_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Capabilities",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QNetworkConfigurationManager(PyObject* module)
{
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QNetworkConfigurationManager_Type);

    SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQtMobility_QNetworkConfigurationManager_Type.type_discovery = &SbkQtMobility_QNetworkConfigurationManager_typeDiscovery;
    Shiboken::BindingManager& bm = Shiboken::BindingManager::instance();
    bm.addClassInheritance(reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX]), &SbkQtMobility_QNetworkConfigurationManager_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QNetworkConfigurationManager_Type) < 0)
        return;

    PyDict_SetItemString(module,"QNetworkConfigurationManager", (PyObject*)&SbkQtMobility_QNetworkConfigurationManager_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: Capability
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
            "Capability",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type));

    // init flags class: QFlags<QtMobility::QNetworkConfigurationManager::Capability>
    SbkQtMobility_BearerTypes[SBK_QFLAGS_QTMOBILITY_QNETWORKCONFIGURATIONMANAGER_CAPABILITY__IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capabilities_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capabilities_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capabilities_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
            "Capabilities",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capabilities_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type,
        (long) QtMobility::QNetworkConfigurationManager::CanStartAndStopInterfaces, "CanStartAndStopInterfaces");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
        "CanStartAndStopInterfaces", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_dict,
        "CanStartAndStopInterfaces", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type,
        (long) QtMobility::QNetworkConfigurationManager::DirectConnectionRouting, "DirectConnectionRouting");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
        "DirectConnectionRouting", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_dict,
        "DirectConnectionRouting", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type,
        (long) QtMobility::QNetworkConfigurationManager::SystemSessionSupport, "SystemSessionSupport");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
        "SystemSessionSupport", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_dict,
        "SystemSessionSupport", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type,
        (long) QtMobility::QNetworkConfigurationManager::ApplicationLevelRoaming, "ApplicationLevelRoaming");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
        "ApplicationLevelRoaming", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_dict,
        "ApplicationLevelRoaming", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type,
        (long) QtMobility::QNetworkConfigurationManager::ForcedRoaming, "ForcedRoaming");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
        "ForcedRoaming", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_dict,
        "ForcedRoaming", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type,
        (long) QtMobility::QNetworkConfigurationManager::DataStatistics, "DataStatistics");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
        "DataStatistics", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_dict,
        "DataStatistics", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type,
        (long) QtMobility::QNetworkConfigurationManager::NetworkSessionRequired, "NetworkSessionRequired");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict,
        "NetworkSessionRequired", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfigurationManager_Capability_Type.tp_dict,
        "NetworkSessionRequired", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QNetworkConfigurationManager::Capability");

    // Initialize signals
    PyObject* signal_item;

    signal_item = PySide::signalNew("onlineStateChanged", "bool", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict, "onlineStateChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("configurationChanged", "const QtMobility::QNetworkConfiguration&", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict, "configurationChanged", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("updateCompleted", "void", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict, "updateCompleted", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("configurationRemoved", "const QtMobility::QNetworkConfiguration&", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict, "configurationRemoved", signal_item);
    Py_DECREF(signal_item);
    signal_item = PySide::signalNew("configurationAdded", "const QtMobility::QNetworkConfiguration&", NULL);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfigurationManager_Type.super.ht_type.tp_dict, "configurationAdded", signal_item);
    Py_DECREF(signal_item);


    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNetworkConfigurationManager >("QtMobility::QNetworkConfigurationManager*");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNetworkConfigurationManager >(typeid(QtMobility::QNetworkConfigurationManager).name());
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNetworkConfigurationManager >(typeid(QNetworkConfigurationManagerWrapper).name());
    PySide::initQtMetaType<QtMobility::QNetworkConfigurationManager* >();
}

