/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <vector>
#include <algorithm>
#include <qsignal.h>
#include <qproperty.h>
#include <pyside.h>
#include <typeresolver.h>
#include <typeinfo>
#include "qtmobility_bearer_python.h"

#include "qtmobility_qnetworkconfiguration_wrapper.h"

// Extra includes
#include <QList>
#include <qnetworkconfiguration.h>

using namespace Shiboken;
using namespace QtMobility;


// Target ---------------------------------------------------------

extern "C" {
static int
SbkQtMobility_QNetworkConfiguration_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    if (Shiboken::isUserType(self) && !Shiboken::canCallConstructor(self->ob_type, Shiboken::SbkType<QtMobility::QNetworkConfiguration >()))
        return -1;

    QtMobility::QNetworkConfiguration* cptr = 0;
    int overloadId = -1;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* arg = 0;

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QNetworkConfiguration", 0, 1, &arg))
        return -1;

    // Overloaded function decisor
    // 0: QNetworkConfiguration()
    // 1: QNetworkConfiguration(QtMobility::QNetworkConfiguration)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkConfiguration()
    } else if (numArgs == 1 && Shiboken::Converter<const QtMobility::QNetworkConfiguration & >::isConvertible(arg)) {
        overloadId = 1; // QNetworkConfiguration(QtMobility::QNetworkConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtMobility_QNetworkConfiguration_Init_TypeError;

    // Call function/method
    {
        switch (overloadId) {
            case 0: // QNetworkConfiguration()
            {

                if(!PyErr_Occurred()) {
                // QNetworkConfiguration()
                cptr = new QtMobility::QNetworkConfiguration();
                }
                break;
            }
            case 1: // QNetworkConfiguration(QtMobility::QNetworkConfiguration)
            {
                if (Shiboken::cppObjectIsInvalid(arg))
                    return -1;
                QtMobility::QNetworkConfiguration* cpp_arg0 = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(arg);

                if(!PyErr_Occurred()) {
                // QNetworkConfiguration(QtMobility::QNetworkConfiguration)
                cptr = new QtMobility::QNetworkConfiguration(*cpp_arg0);
                }
                break;
            }
        }
        }
    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QtMobility::QNetworkConfiguration >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQtMobility_QNetworkConfiguration_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    SbkQtMobility_QNetworkConfiguration_Init_TypeError:
        const char* overloads[] = {"", "QtMobility.Bearer.QtMobility::QNetworkConfiguration", 0};
        Shiboken::setErrorAboutWrongArguments(args, "QtMobility.Bearer.QNetworkConfiguration", overloads);
        return -1;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_bearerName(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // bearerName()const
            QString cppResult = cppSelf->QtMobility::QNetworkConfiguration::bearerName();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_children(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // children()const
            QList<QtMobility::QNetworkConfiguration > cppResult = cppSelf->QtMobility::QNetworkConfiguration::children();
            pyResult = Shiboken::Converter<QList<QtMobility::QNetworkConfiguration > >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_identifier(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // identifier()const
            QString cppResult = cppSelf->QtMobility::QNetworkConfiguration::identifier();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_isRoamingAvailable(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isRoamingAvailable()const
            bool cppResult = cppSelf->QtMobility::QNetworkConfiguration::isRoamingAvailable();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_isValid(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = cppSelf->QtMobility::QNetworkConfiguration::isValid();
            pyResult = Shiboken::Converter<bool >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_name(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // name()const
            QString cppResult = cppSelf->QtMobility::QNetworkConfiguration::name();
            pyResult = Shiboken::Converter<QString >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_purpose(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // purpose()const
            QtMobility::QNetworkConfiguration::Purpose cppResult = cppSelf->QtMobility::QNetworkConfiguration::purpose();
            pyResult = Shiboken::Converter<QtMobility::QNetworkConfiguration::Purpose >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_state(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // state()const
            QFlags<QtMobility::QNetworkConfiguration::StateFlag> cppResult = cppSelf->QtMobility::QNetworkConfiguration::state();
            pyResult = Shiboken::Converter<QFlags<QtMobility::QNetworkConfiguration::StateFlag> >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyObject* SbkQtMobility_QNetworkConfigurationFunc_type(PyObject* self)
{
    QtMobility::QNetworkConfiguration* cppSelf = 0;
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;
    cppSelf = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    PyObject* pyResult = 0;

    // Call function/method
    {
        {

            if(!PyErr_Occurred()) {
            // type()const
            QtMobility::QNetworkConfiguration::Type cppResult = cppSelf->QtMobility::QNetworkConfiguration::type();
            pyResult = Shiboken::Converter<QtMobility::QNetworkConfiguration::Type >::toPython(cppResult);
            }
        }
        }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return 0;
    }
    return pyResult;
}

static PyMethodDef SbkQtMobility_QNetworkConfiguration_methods[] = {
    {"bearerName", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_bearerName, METH_NOARGS},
    {"children", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_children, METH_NOARGS},
    {"identifier", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_identifier, METH_NOARGS},
    {"isRoamingAvailable", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_isRoamingAvailable, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_isValid, METH_NOARGS},
    {"name", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_name, METH_NOARGS},
    {"purpose", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_purpose, METH_NOARGS},
    {"state", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_state, METH_NOARGS},
    {"type", (PyCFunction)SbkQtMobility_QNetworkConfigurationFunc_type, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQtMobility_QNetworkConfiguration_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QtMobility::QNetworkConfiguration& cpp_self = *Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<const QtMobility::QNetworkConfiguration & >::isConvertible(other)) {
                // operator!=(const QtMobility::QNetworkConfiguration & cp) const
                QtMobility::QNetworkConfiguration* cpp_other = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QNetworkConfiguration  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQtMobility_QNetworkConfiguration_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<const QtMobility::QNetworkConfiguration & >::isConvertible(other)) {
                // operator==(const QtMobility::QNetworkConfiguration & cp) const
                QtMobility::QNetworkConfiguration* cpp_other = Shiboken::Converter<QtMobility::QNetworkConfiguration* >::toCpp(other);
                result = !cpp_other ? cpp_self == Shiboken::Converter< QtMobility::QNetworkConfiguration  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQtMobility_QNetworkConfiguration_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQtMobility_QNetworkConfiguration_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

} // extern "C"

// Class Definition -----------------------------------------------
extern "C" {
static SbkBaseWrapperType SbkQtMobility_QNetworkConfiguration_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "QtMobility.Bearer.QNetworkConfiguration",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQtMobility_QNetworkConfiguration_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtMobility_QNetworkConfiguration_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQtMobility_QNetworkConfiguration_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QtMobility::QNetworkConfiguration >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0,
    /*original_name*/       "QtMobility::QNetworkConfiguration",
    /*user_data*/           0
};
} //extern

static PyGetSetDef SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Purpose",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Type",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___and__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags >::checkType(self) && Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "&", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QNetworkConfiguration::StateFlags >::toPython(
        Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags>::toCpp(self)
        & Shiboken::Converter< QtMobility::QNetworkConfiguration::StateFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___or__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags >::checkType(self) && Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "|", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QNetworkConfiguration::StateFlags >::toPython(
        Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags>::toCpp(self)
        | Shiboken::Converter< QtMobility::QNetworkConfiguration::StateFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___xor__(PyObject* self, PyObject* arg)
{
    if (Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags >::checkType(self) && Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags >::checkType(arg))
    {
        PyErr_Format(PyExc_TypeError, "unsupported operand type(s) for %s: '%s' and '%s'", "^", self->ob_type->tp_name, arg->ob_type->tp_name);
        return 0;
    }

    return Shiboken::Converter< QtMobility::QNetworkConfiguration::StateFlags >::toPython(
        Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags>::toCpp(self)
        ^ Shiboken::Converter< QtMobility::QNetworkConfiguration::StateFlags >::toCpp(arg)
    );
}

PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtMobility::QNetworkConfiguration::StateFlags >::toPython(
        ~Shiboken::Converter<QtMobility::QNetworkConfiguration::StateFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StateFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyTypeObject SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StateFlags",
    /*tp_basicsize*/        0,
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type.tp_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              PyInt_Type.tp_new,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};



void init_QtMobility_QNetworkConfiguration(PyObject* module)
{
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQtMobility_QNetworkConfiguration_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_QNetworkConfiguration_Type) < 0)
        return;

    PyDict_SetItemString(module,"QNetworkConfiguration", (PyObject*)&SbkQtMobility_QNetworkConfiguration_Type);
    // Initialize enums
    PyObject* enum_item;

    // init enum class: Purpose
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_PURPOSE_IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
            "Purpose",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type,
        (long) QtMobility::QNetworkConfiguration::UnknownPurpose, "UnknownPurpose");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "UnknownPurpose", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type.tp_dict,
        "UnknownPurpose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type,
        (long) QtMobility::QNetworkConfiguration::PublicPurpose, "PublicPurpose");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "PublicPurpose", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type.tp_dict,
        "PublicPurpose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type,
        (long) QtMobility::QNetworkConfiguration::PrivatePurpose, "PrivatePurpose");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "PrivatePurpose", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type.tp_dict,
        "PrivatePurpose", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type,
        (long) QtMobility::QNetworkConfiguration::ServiceSpecificPurpose, "ServiceSpecificPurpose");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "ServiceSpecificPurpose", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Purpose_Type.tp_dict,
        "ServiceSpecificPurpose", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QNetworkConfiguration::Purpose");

    // init enum class: Type
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_TYPE_IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
            "Type",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type,
        (long) QtMobility::QNetworkConfiguration::InternetAccessPoint, "InternetAccessPoint");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "InternetAccessPoint", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type.tp_dict,
        "InternetAccessPoint", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type,
        (long) QtMobility::QNetworkConfiguration::ServiceNetwork, "ServiceNetwork");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "ServiceNetwork", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type.tp_dict,
        "ServiceNetwork", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type,
        (long) QtMobility::QNetworkConfiguration::UserChoice, "UserChoice");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "UserChoice", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type.tp_dict,
        "UserChoice", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type,
        (long) QtMobility::QNetworkConfiguration::Invalid, "Invalid");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "Invalid", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_Type_Type.tp_dict,
        "Invalid", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QNetworkConfiguration::Type");

    // init enum class: StateFlag
    SbkQtMobility_BearerTypes[SBK_QTMOBILITY_QNETWORKCONFIGURATION_STATEFLAG_IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
            "StateFlag",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type));

    // init flags class: QFlags<QtMobility::QNetworkConfiguration::StateFlag>
    SbkQtMobility_BearerTypes[SBK_QFLAGS_QTMOBILITY_QNETWORKCONFIGURATION_STATEFLAG__IDX] = &SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlags_Type) < 0)
        return;
    Py_INCREF(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlags_Type);
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
            "StateFlags",((PyObject*)&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type,
        (long) QtMobility::QNetworkConfiguration::Undefined, "Undefined");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "Undefined", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type.tp_dict,
        "Undefined", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type,
        (long) QtMobility::QNetworkConfiguration::Defined, "Defined");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "Defined", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type.tp_dict,
        "Defined", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type,
        (long) QtMobility::QNetworkConfiguration::Discovered, "Discovered");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "Discovered", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type.tp_dict,
        "Discovered", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type,
        (long) QtMobility::QNetworkConfiguration::Active, "Active");
    PyDict_SetItemString(SbkQtMobility_QNetworkConfiguration_Type.super.ht_type.tp_dict,
        "Active", enum_item);
    PyDict_SetItemString(SbkQtMobility_Bearer_QtMobility_QNetworkConfiguration_StateFlag_Type.tp_dict,
        "Active", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtMobility::QNetworkConfiguration::StateFlag");


    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QNetworkConfiguration >("QtMobility::QNetworkConfiguration");
    Shiboken::TypeResolver::createObjectTypeResolver<QtMobility::QNetworkConfiguration >("QtMobility::QNetworkConfiguration*");
    Shiboken::TypeResolver::createValueTypeResolver<QtMobility::QNetworkConfiguration >(typeid(QtMobility::QNetworkConfiguration).name());
    PySide::initQtMetaType<QtMobility::QNetworkConfiguration >();
}

