#Import, of course
import sys,os

from libpiano.pandora import Pandora
from PySide import QtCore

class RadioPlayer(QtCore.QThread): #Main radio class
	def __init__( self, Parent=None ):
		self.os = self.get_product()
		self.playlist = []
		self.state = 0
		print self.os
		if self.os == "RX-51": #Check for N900 or Diablo
			from libpiano.MAFWBackend import MAFWBackend
			self.player = MAFWBackend()
		elif self.os == "MeeGo":
			from libpiano.GstBackend import GstBackend
			self.player = GstBackend()
		#	print "Here"
		elif self.os == "RX-44":
			from libpiano.OSSOBackend import OSSOBackend
			self.player = OSSOBackend()
		else:
			from libpiano.GstBackend import GstBackend
			self.player = GstBackend()

		QtCore.QObject.connect(self.player, QtCore.SIGNAL("eof"), self.sigEOF)
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("state_change(int)"), self.stateChange)
		QtCore.QObject.connect(self.player, QtCore.SIGNAL("pos_changed(int,int)"), self.updateTime)
		self.format = 'aacplus'
		self.protocol_version = 0
		self.proxy = ""
		self.pandora = None

		QtCore.QThread.__init__(self)

	def run(self):
		self.pandora = Pandora( self.format, self.protocol_version )
		if len(self.proxy) > 0:
		    self.pandora.set_proxy(self.proxy)
		print "Radio Started."

	def get_product( self ): #Find Product ID
		try:
			lines = open("/proc/component_version", "r").readlines()
		except:
			try: lines = open("/etc/meego-release", "r").readlines()
			except: lines = []

		product = "?"
		for line in lines:
			line = line.strip()
			if (line.startswith("product")):
				parts = line.split()
				product = parts[1].strip()
				break
			elif (line.startswith("MeeGo")):
				product = "MeeGo"
		#end for
		return product

	def updateTime( self, pos, total ): #Update position/duration
		#print "%02d:%02d" % divmod(self.duration[1], 60)
		if total > 0:
			self.emit(QtCore.SIGNAL("duration(int,int)"),pos,total)

	def stateChange( self, state ): #Update backend state change
		self.state = state
		if state == 2:
			print "Paused"
		elif state == 1:
			print "Playing"
		self.emit(QtCore.SIGNAL("state_change"))

	def setVolume( self, volume ):
		self.player.set_volume( volume )

	def createStation( self, stationId ): #Create a station at Pandora
		ret = self.pandora.createStation( stationId )
		return ret["stationId"]

	def search( self, search ): #Search Pandora
		ret = self.pandora.searchPandora( str(search) )
		return ret

	def auth( self, user, password ): #Authenticate to Pandora
		self.pandora.sync()
		ret = self.pandora.authListener( str(user), str(password) )
		return ret

	def play( self, url, item ): #Load URL/Song into Backend
		self.player.load_audio(url)

	def stopPlayBack ( self ): #Pause or Stop
		self.player.pause()

	def startPlayBack ( self ): #Resume after Pause
		self.player.play()

	def sigEOF( self ):
		print "EOF called."
		self.emit(QtCore.SIGNAL("EOF"))

	def loveHate( self, song, rating ): #Do Love/Hate based on variable settings
		return self.pandora.addFeedback( song[1]["stationId"], song, rating )

	def doSeed( self, musicId, station ):
		return self.pandora.addSeed( station, musicId )

	def doTired( self, song ): #Mark tired
		return self.pandora.setTired( song[1]["identity"] )

	def doDelete( self, station ): #Delete station
		return self.pandora.deleteStation( station )

	def getStations( self ): #Get station list, sort alphabetically.
		return sorted(self.pandora.getStations(), key=lambda station: station["stationName"])

	def getMoreSongs( self, station, format ): #Get next 3 or so songs
		items = []
		fragment = self.pandora.getFragment( station, format )
		for s in fragment:
			#print s
			#print "\n"
			print s["songTitle"], "by", s["artistSummary"]
			item = None
			item = { "title" : s["songTitle"], \
			"artist"	:	s["artistSummary"], \
			"genre"		:	"".join(s["genre"]), \
			"album"		:	s["albumTitle"], \
			"rating"	:	s["rating"], \
			"art"		: s["artRadio"], \
			"matchingSeed"	: s["matchingSeed"], \
			"userSeed"	: s["userSeed"], \
			"focusTraitId"	: s["focusTraitId"], \
			"stationId"	: s["stationId"], \
			"identity"	: s["identity"], \
			"musicId"	: s["musicId"], \
			"artistMusicId" : s["artistMusicId"] }
			items.append( ( s["audioURL"], item ) )
		self.playlist.extend( items )

	def close( self ): #Close Pandora and Backend
		self.player.stop()
		self.player.close()
		self.player = None
		self.pandora = None
