#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
#    Author (maemo port): Julius Sipilä
#    Email: julius.sipila@gmail.com
#    Original Author: Jay Deiman
#    Email: admin@splitstreams.com
#
#    This file is part of a pylibgal3 port to Nokia N900/ maemo Fremantle.
#    The port also includes a client script 'g3_share' which can be used
#    on N900 together with the Command-Line sharing plugin.
#
#    pylibgal3 is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    pylibgal3 is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with pylibgal3.  If not, see <http://www.gnu.org/licenses/>.
#


from distutils.core import setup
import sys

setup(name='pylibgal3' ,
    version='0.1.4maemo1' ,
    author='Julius Sipilä' ,
    author_email='julius.sipila@gmail.com' ,
    url='http://stuffivelearned.org' ,
    description='A library + client script for uploading pics to Gallery3' ,
    scripts=['g3_share'] ,   
    packages=['libg3'] ,
    package_dir={'libg3': 'libg3'} ,
    long_description = """A Python library + client script for accessing a Gallery3 install
(gallery.menalto.com) using the REST API.

Can be used from the command line or preferably with the Command-Line Sharing plugin.
When using the Command-Line Sharing plugin use a command like this in the plugin setup:
g3_share -i %s -o %s -s your.gallery.com -b /gallery3 -d "Test/Incoming Pics" -u g3_username -p g3_password""" ,
)
