#include "helpwindow.h"
#include "ui_helpwindow.h"

HelpWindow::HelpWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::HelpWindow)
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    ui->setupUi(this);
    qDebug() << "HelpWindow: UI ready.";
#ifdef Q_WS_MAEMO_5
    HelpWindow::setAttribute(Qt::WA_Maemo5AutoOrientation, false);
    HelpWindow::setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
#endif
//    ui->kernelMessagesButton->hide();
    ui->imageLabel->setPixmap(QPixmap(":/images/version.png"));
    //ui->imageLabel->paintEngine();
    connect(ui->phatButton, SIGNAL(clicked()), this, SLOT(phat()));
    connect(ui->slimButton, SIGNAL(clicked()), this, SLOT(slim()));
}

HelpWindow::~HelpWindow()
{
    qDebug() << "HelpWindow: deleting UI...";
    delete ui;
}

void HelpWindow::phat()
{
    qDebug() << "HelpWindow: showing Phat help widgets.";
    HelpWindow::showhelpPhat();
}

void HelpWindow::slim()
{
    qDebug() << "HelpWindow: showing Slim help widgets.";
    HelpWindow::showhelpSlim();
}

void HelpWindow::showhelpPhat()
{
    ui->phatButton->hide();
    ui->slimButton->hide();
    ui->imageLabel->hide();
    HDraggableViewArea *views = new HDraggableViewArea(ui->widget);
    views->addWidget(new DisplayPage(":/images/phat1.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/phat2.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/phat3.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/phat4.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/page5.png", ui->widget));
    this->setCentralWidget(views);
    kernelMessagesButton = new QPushButton(views);
    kernelMessagesButton->hide();
    views->show();
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(0, tr("<--- Swipe left and right to move between images --->"));
#endif
    connect(views, SIGNAL(slidTo(int)), this, SLOT(showKernelButton(int)));
}

void HelpWindow::showhelpSlim()
{
    ui->phatButton->hide();
    ui->slimButton->hide();
    ui->imageLabel->hide();
    HDraggableViewArea *views = new HDraggableViewArea(ui->widget);
    views->addWidget(new DisplayPage(":/images/slim1.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/slim2.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/slim3.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/slim4.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/page5.png", ui->widget));
    this->setCentralWidget(views);
    views->show();
//    HelpWindow::showFullScreen();
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(0, tr("<--- Swipe left and right to move between images --->"));
#endif
    connect(views, SIGNAL(slidTo(int)), this, SLOT(showKernelButton(int)));
}

void HelpWindow::showKernelButton(int page)
{
    qDebug() << "HelpWindow: on page:" << page + 1;
/*    unsigned int pagenumber = page + 1;
    qDebug() << pagenumber;
    if (pagenumber == '5')
        kernelMessagesButton->show();
    else
        kernelMessagesButton->hide();*/
}
