#include "aboutwindow.h"
#include "ui_aboutwindow.h"
#include "qwebviewselectionsuppressor.h"
#ifdef Q_WS_MAEMO_5
    #include <QtGui/qabstractkineticscroller.h>
#endif

AboutWindow::AboutWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::AboutWindow)
{
    ui->setupUi(this);
    qDebug() << "AboutWindow: UI ready.";
    QMainWindow::setCentralWidget(ui->webView);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
    ui->webView->property("kineticScroller").value<QAbstractKineticScroller *>()->setEnabled(true);
    qDebug() << "AboutWindow: On Maemo 5, kinetic scrolling enabled.";
#endif
    qDebug() << "AboutWindow: Opening file:///opt/psfreedom/resources/aboutpsfreedom.html";
    ui->webView->setUrl(QUrl("file:///opt/psfreedom/resources/aboutpsfreedom.html"));
}

AboutWindow::~AboutWindow()
{
    delete ui;
}
