#ifndef SCROLL_AREA_H
#define SCROLL_AREA_H

#include "RXSupport_global.h"

#include <QWidget>
#include <QMouseEvent>
#include <QPropertyAnimation>

#include <vector>

class RXSUPPORTSHARED_EXPORT DraggableViewArea: public QWidget
{
    Q_OBJECT

public:
    explicit     DraggableViewArea  (Qt::Orientation orientation, QWidget *parent = 0);

    void         addWidget          (QWidget *widget);

signals:
    void         slidTo             (int index);
    void         slidTo             (QWidget *widget);

public slots:
    void         jumpTo             (int index);
    void         jumpTo             (QWidget *widget);

    void         slideTo            (int index);
    void         slideTo            (QWidget *widget);

protected slots:
    void         animationFinished  ();

protected:
    bool         eventFilter        (QObject *object, QEvent *event);

    void         mousePressEvent    (QMouseEvent *event);
    void         mouseMoveEvent     (QMouseEvent *event);
    void         mouseReleaseEvent  (QMouseEvent *event);

    static DraggableViewArea    *dragging;

    Qt::Orientation              m_Orientation;

    QWidget                     *m_Content;

    std::vector<QWidget *>       m_ChildWidgets;
    int                          m_CurrentIndex;

    QPropertyAnimation          *m_Transition;

    QPoint                       m_MouseAnchor;
    QPointF                      m_MouseAnchorFiltered;
};

class HDraggableViewArea : public DraggableViewArea {
public:
    explicit HDraggableViewArea(QWidget *parent = 0)
        : DraggableViewArea(Qt::Horizontal, parent) { /* ... */ }
};

class VDraggableViewArea : public DraggableViewArea {
public:
    explicit VDraggableViewArea(QWidget *parent = 0)
        : DraggableViewArea(Qt::Vertical, parent) { /* ... */ }
};

#endif
