#include <QtDebug>
#include <QtGui/QApplication>
#include <QtGui/QDialogButtonBox>
#include <QFile>
#include <QLibraryInfo>
#include <QLocale>
#include <QTextStream>
#include <QTranslator>
#include "profilechangerwidget.h"

void customMessageHandler(QtMsgType type, const char *msg)
{
        QString txt;
        switch (type) {
        case QtDebugMsg:
                txt = QString("Debug: %1").arg(msg);
                break;

        case QtWarningMsg:
                txt = QString("Warning: %1").arg(msg);
        break;
        case QtCriticalMsg:
                txt = QString("Critical: %1").arg(msg);
        break;
        case QtFatalMsg:
                txt = QString("Fatal: %1").arg(msg);
        }

        QFile outFile(PCW_APP_LOGFILE);
        outFile.open(QIODevice::WriteOnly | QIODevice::Append);
        QTextStream ts(&outFile);
        ts << txt << endl;
        outFile.close();
        if ( type==QtFatalMsg ) abort();
}

int main(int argc, char *argv[])
{
    QApplication::setOrganizationName("hschmitt");
    QApplication::setApplicationName("profile-changer-widget");
    QApplication::setApplicationVersion(PCW_APP_VERSION);

    // enforce native graphics system for now due to a bug in transparency handling
    // you can remove this line if you only target PR 1.2
    if (qstrcmp(qVersion(), "4.7.2") == 0) {
            QApplication::setGraphicsSystem("native");
    }

    QApplication app(argc, argv);

    //Lets register our custom handler, before we start
    QSettings settings;
    if(settings.value(PCW_SETTING_DEBUG, PCW_SETTING_DEBUG_DEFAULT).toBool()) {
        qInstallMsgHandler(customMessageHandler);
    }

    qDebug() << "Starting " << QApplication::applicationName() << " version " << QApplication::applicationVersion();
    qDebug() << "Built with QT " << QT_VERSION_STR << " running with " << qVersion();

    //Translate it
    qDebug() << "Trying to install Translators for lang " << QLocale::system().name();
    QTranslator qtTranslator;
    bool res = qtTranslator.load(QLatin1String("qt_") + QLocale::system().name(),
            QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    app.installTranslator(&qtTranslator);
    qDebug() << "Translator qt_ sucess=" << res;

    QTranslator pcwTranslator;
    res = pcwTranslator.load("profilechangerwidget_" + QLocale::system().name(), "/opt/profilechangerwidget");
    app.installTranslator(&pcwTranslator);
    qDebug() << "Translator profilechangerwidget_ sucess=" << res;
    qDebug() << "Translate Done to " << QDialogButtonBox::tr("Done");

    ProfileChangerWidget w;

    QMaemo5HomescreenAdaptor adaptor(&w);
    adaptor.setSettingsAvailable(true);
    QObject::connect(&adaptor, SIGNAL(settingsRequested()), &w, SLOT(onShowSettingsDialog()));
    QObject::connect(&adaptor, SIGNAL(homescreenChanged(bool)), &w, SLOT(onHomeScreenChanged(bool)));

    w.show();

    return app.exec();
}

