#include "simulation/Elements.h"
//#TPT-Directive ElementClass Element_BGLA PT_BGLA 47
Element_BGLA::Element_BGLA()
{
	Identifier = "DEFAULT_PT_BGLA";
	Name = "BGLA";
	Colour = PIXPACK(0x606060);
	MenuVisible = 1;
	MenuSection = SC_POWDERS;
	Enabled = 1;
	
	Advection = 0.4f;
	AirDrag = 0.04f * CFDS;
	AirLoss = 0.94f;
	Loss = 0.95f;
	Collision = -0.1f;
	Gravity = 0.3f;
	Diffusion = 0.00f;
	HotAir = 0.000f	* CFDS;
	Falldown = 1;
	
	Flammable = 0;
	Explosive = 0;
	Meltable = 5;
	Hardness = 0;
	
	Weight = 90;
	
	Temperature = R_TEMP+0.0f	+273.15f;
	HeatConduct = 150;
	Description = "Broken Glass, heavy particles formed when glass breaks under pressure. Meltable. Bagels.";
	
	State = ST_SOLID;
	Properties = TYPE_PART | PROP_HOT_GLOW;
	
	LowPressure = IPL;
	LowPressureTransition = NT;
	HighPressure = IPH;
	HighPressureTransition = NT;
	LowTemperature = ITL;
	LowTemperatureTransition = NT;
	HighTemperature = 1973.0f;
	HighTemperatureTransition = PT_LAVA;
	
	Update = NULL;
	
}

Element_BGLA::~Element_BGLA() {}
