#!/usr/bin/env python

import pygtk
import gtk
import ConfigParser
import dircache
import hildon
import shutil


class HelloWorld:
    def hello(self, widget, data=None):
        print "Hello World"

    def delete_event(self, widget, event, data=None):
        return False

    def destroy(self, widget, data=None):
        gtk.main_quit()

    def item_toggled(self, widget, name):
	if widget.get_active():
	    shutil.move(self.basedir + 'disabled/' + name, self.basedir + name)
	else:
	    shutil.move(self.basedir + name, self.basedir + 'disabled/' + name)

    def __init__(self):
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.window.connect("delete_event", self.delete_event)
        self.window.connect("destroy", self.destroy) 
        self.window.set_border_width(10)
        self.window.set_title("Powatool")

	self.basedir = '/usr/share/applications/hildon-status-menu/'

	self.pa = hildon.PannableArea()
	self.pa.show()
	self.vb = gtk.VBox()
	self.vb.show()	
	self.pa.add_with_viewport(self.vb)
	l = gtk.Label('Enable and disable plugins. Both status menu and status aera plugins are listed. Your actions will be reflected immediatelly.')
	l.set_line_wrap(True)
	l.show()
	l.set_justify(gtk.JUSTIFY_LEFT)
	self.vb.pack_start(l, True, True, 0)
	
	#First load active plugins
	filez = dircache.listdir(self.basedir);
	for aFile in filez:
	    desktop = ConfigParser.RawConfigParser()
	    desktop.read(self.basedir + aFile)
	    if desktop.has_option('Desktop Entry', 'Name'):
		name = desktop.get('Desktop Entry', 'Name')
		b = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		b.set_label(name)
		b.set_active(True)
		b.connect("toggled", self.item_toggled, aFile)
		b.show()
		self.vb.pack_start(b, True, True, 0)
	#Second load inactive plugins
	filez = dircache.listdir(self.basedir + 'disabled/');
	for aFile in filez:
	    desktop = ConfigParser.RawConfigParser()
	    desktop.read(self.basedir + 'disabled/' + aFile)
	    if desktop.has_option('Desktop Entry', 'Name'):
		name = desktop.get('Desktop Entry', 'Name')
		b = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		b.set_label(name)
		b.set_active(False)
		b.connect("toggled", self.item_toggled, aFile)
		b.show()
		self.vb.pack_start(b, True, True, 0)
	self.window.add(self.pa)
        self.window.show()

    def main(self):
        gtk.main()

if __name__ == "__main__":
    hello = HelloWorld()
    hello.main()

