#ifndef _QUERY_TREE_MODEL_H_
#define _QUERY_TREE_MODEL_H_

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define DEFAULT_QUERY_ICON_FNAME "/usr/share/icons/hicolor/48x48/hildon/pogacsa.png"

enum {
	QUERY_TREE_MODEL_IMAGE = 0,
	QUERY_TREE_MODEL_NAME,
	QUERY_TREE_MODEL_QUERY,
	QUERY_TREE_MODEL_ICON_PATH,
	QUERY_TREE_MODEL_N_COLS,
};

GtkTreeModel *query_tree_model_new();
void          query_tree_model_set(GtkTreeModel *tm, GtkTreeIter *itr, char *name, char *query, char *icon_fname);
GdkPixbuf    *query_tree_model_make_image(char *fname);
void          query_tree_model_delete(GtkTreeModel *tm, GtkTreeIter *itr);
void          query_tree_model_move(GtkTreeModel *tm, GtkTreeIter *itr, gboolean up);

G_END_DECLS

#endif /* !_QUERY_TREE_MODEL_H_ */
