#include <stdlib.h>
#include <hildon/hildon.h>
#include <hildon/hildon-file-chooser-dialog.h>
#include "add-edit-query-dialog.h"
#include "intl.h"

typedef struct {
	GtkTreeRowReference *trr;
	GtkWidget *dlg;
	GtkTreeModel *tm;
	GtkWidget *image;
	GtkWidget *name_entry;
	GtkWidget *query_entry;
	guint row_deleted_signal_id;
	guint row_changed_signal_id;
} AddEditDialogParams;

enum {
	EDIT_QUERY_SAVE,
};

static void
home_button_clicked(GtkWidget *button, gpointer null)
{
	GtkWidget *toplevel = gtk_widget_get_toplevel(button);

	if (toplevel)
		if (GTK_IS_FILE_CHOOSER(toplevel))
			gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(toplevel), getenv("HOME"));
}

static GtkWidget *
make_home_button()
{
	GtkWidget *btn = g_object_new(HILDON_TYPE_BUTTON,
		"size",        HILDON_SIZE_FINGER_HEIGHT,
		"arrangement", HILDON_BUTTON_ARRANGEMENT_HORIZONTAL,
		"visible",     TRUE,
		"label",       GTK_STOCK_HOME,
		"use-stock",   TRUE,
		NULL);

	g_signal_connect(G_OBJECT(btn), "clicked", (GCallback)home_button_clicked, NULL);

	return btn;
}

static void
image_button_clicked(GtkWidget *button, AddEditDialogParams *params)
{
	char *fname = NULL;
	GtkWidget *file_sel = 
		g_object_new(HILDON_TYPE_FILE_CHOOSER_DIALOG,
			"visible",       TRUE,
			"transient-for", gtk_widget_get_toplevel(button),
			"action",        GTK_FILE_CHOOSER_ACTION_OPEN,
			"local-only",    TRUE,
			NULL);

	hildon_file_chooser_dialog_add_extra(HILDON_FILE_CHOOSER_DIALOG(file_sel), make_home_button());
	gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(file_sel), g_object_get_data(G_OBJECT(params->image), "file"));

	gtk_dialog_run(GTK_DIALOG(file_sel));

	fname = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(file_sel));

	g_object_set_data_full(G_OBJECT(params->image), "file", fname, (GDestroyNotify)g_free);
	g_object_set(G_OBJECT(params->image), "pixbuf", query_tree_model_make_image(fname), NULL);

	gtk_widget_destroy(file_sel);
}

static gboolean
gtk_tree_row_reference_get_iter(GtkTreeRowReference *trr, GtkTreeIter *itr)
{
	gboolean ret = FALSE;
	if (trr) {
		GtkTreePath *tp = gtk_tree_row_reference_get_path(trr);

		if (tp) {
			ret = gtk_tree_model_get_iter(gtk_tree_row_reference_get_model(trr), itr, tp);
			gtk_tree_path_free(tp); tp = NULL;
		}
	}
	return ret;
}

static void
add_edit_response(GtkWidget *dlg, guint response_id, AddEditDialogParams *params)
{
	if (params->row_deleted_signal_id)
		g_signal_handler_disconnect(G_OBJECT(params->tm), params->row_deleted_signal_id);
	if (params->row_changed_signal_id)
		g_signal_handler_disconnect(G_OBJECT(params->tm), params->row_changed_signal_id);

	if (EDIT_QUERY_SAVE == response_id) {
		GtkTreeIter itr;
		gboolean valid;
		char *fname = NULL;

		fname = g_object_get_data(G_OBJECT(params->image), "file");
		valid = gtk_tree_row_reference_get_iter(params->trr, &itr);

		query_tree_model_set(params->tm, valid ? &itr : NULL,
			(char *)gtk_entry_get_text(GTK_ENTRY(params->name_entry)),
			(char *)gtk_entry_get_text(GTK_ENTRY(params->query_entry)),
			fname);
	}

	gtk_tree_row_reference_free(params->trr); params->trr = NULL;
	gtk_widget_hide(dlg);
	gtk_widget_destroy(dlg);
}

static void
query_entry_size_allocate(GtkWidget *entry, GtkAllocation *alloc, GtkWidget *label)
{
	gtk_widget_set_size_request(label, alloc->width, -1);
}

static void
set_new_query(AddEditDialogParams *params)
{
	gtk_window_set_title(GTK_WINDOW(params->dlg), _("Add Query"));
}

static void
tm_row_deleted(GtkTreeModel *tm, GtkTreePath *tp, AddEditDialogParams *params)
{
	g_print("tm_row_deleted\n");

	if (!gtk_tree_row_reference_valid(params->trr)) {
		set_new_query(params);
		gtk_tree_row_reference_free(params->trr); params->trr = NULL;
	}
}

static void
set_from_iter(AddEditDialogParams *params, GtkTreeModel *tm, GtkTreeIter *itr)
{
	GdkPixbuf *pb;
	char *name, *query, *icon_path;

	gtk_tree_model_get(tm, itr,
		QUERY_TREE_MODEL_IMAGE,     &pb,
		QUERY_TREE_MODEL_NAME,      &name,
		QUERY_TREE_MODEL_QUERY,     &query,
		QUERY_TREE_MODEL_ICON_PATH, &icon_path,
		-1);

	g_object_set(G_OBJECT(params->image), "pixbuf", pb, NULL);
	g_object_set_data_full(G_OBJECT(params->image), "file", icon_path, (GDestroyNotify)g_free);
	gtk_entry_set_text(GTK_ENTRY(params->name_entry), name);
	gtk_entry_set_text(GTK_ENTRY(params->query_entry), query);

	g_free(name); name = NULL;
	g_free(query); query = NULL;
}
/*
static void
tm_row_changed(GtkTreeModel *tm, GtkTreePath *tp, AddEditDialogParams *params)
{
	GtkTreeIter itr;
	int my_idx = -1;
	int changed_idx = -1;

	g_print("tm_row_changed\n");

	if (gtk_tree_row_reference_get_iter(params->trr, &itr))
		gtk_tree_model_get(tm, &itr, QUERY_TREE_MODEL_INDEX, &my_idx);
	if (gtk_tree_model_get_iter(tm, &itr, tp))
		gtk_tree_model_get(tm, &itr, QUERY_TREE_MODEL_INDEX, &changed_idx);

	if (changed_idx == my_idx && my_idx != -1)
		set_from_iter(params, tm, &itr);
}
*/
void
add_edit_query_dialog_run(GtkWidget *parent, GtkTreeModel *tm, GtkTreeIter *itr)
{
	GtkWidget *explanation_label;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *image_button;
	AddEditDialogParams *params = g_new0(AddEditDialogParams, 1);

	params->tm = tm;
	params->dlg = gtk_dialog_new_with_buttons(_("Edit Query"), GTK_WINDOW(parent), 0, NULL);
	g_object_set_data_full(G_OBJECT(params->dlg), "params", params, (GDestroyNotify)g_free);
	gtk_dialog_add_button(GTK_DIALOG(params->dlg), GTK_STOCK_SAVE, EDIT_QUERY_SAVE);
	g_signal_connect(G_OBJECT(params->dlg), "response", (GCallback)add_edit_response, params);

	params->image = g_object_new(GTK_TYPE_IMAGE, "visible", TRUE, "pixbuf", query_tree_model_make_image(DEFAULT_QUERY_ICON_FNAME), NULL);
	g_object_set_data_full(G_OBJECT(params->image), "file", g_strdup(DEFAULT_QUERY_ICON_FNAME), (GDestroyNotify)g_free);
	image_button = g_object_new(HILDON_TYPE_BUTTON,
		"size",        HILDON_SIZE_FINGER_HEIGHT,
		"arrangement", HILDON_BUTTON_ARRANGEMENT_HORIZONTAL,
		"visible",     TRUE,
		"child",       params->image,
		NULL);

	hbox = g_object_new(GTK_TYPE_HBOX, "visible", TRUE,
		"spacing", HILDON_MARGIN_DEFAULT,
		"border-width", HILDON_MARGIN_DEFAULT,
		NULL);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(params->dlg)->vbox), hbox);

	gtk_box_pack_start(GTK_BOX(hbox),
		g_object_new(GTK_TYPE_ALIGNMENT, "visible", TRUE, "xscale", 0.0, "yscale", 0.0, "xalign", 0.0, "yalign", 0.0,
			"child", image_button, NULL), FALSE, TRUE, 0);
	g_signal_connect(G_OBJECT(image_button), "clicked", (GCallback)image_button_clicked, params);

	vbox = g_object_new(GTK_TYPE_VBOX, "visible", TRUE, NULL);
	gtk_container_add(GTK_CONTAINER(hbox), vbox);
	
	params->name_entry = g_object_new(HILDON_TYPE_ENTRY, "visible", TRUE, "width-chars", 11, NULL);
	hildon_entry_set_placeholder(HILDON_ENTRY(params->name_entry), _("Name"));
	gtk_container_add(GTK_CONTAINER(vbox), params->name_entry);

	params->query_entry = g_object_new(HILDON_TYPE_ENTRY, "visible", TRUE, "width-chars", 11, NULL);
	hildon_entry_set_placeholder(HILDON_ENTRY(params->query_entry), _("URL"));
	gtk_container_add(GTK_CONTAINER(vbox), params->query_entry);

	explanation_label = g_object_new(GTK_TYPE_LABEL,
		"visible", TRUE,
		"label",
			_("Use '{}' as a placeholder for fields you will type in. Use %7B for a literal '{' and %7D for a literal '}'."),
		"justify", GTK_JUSTIFY_LEFT,
		"xalign", 0.0,
		"yalign", 0.5,
		"wrap", TRUE,
		NULL);
	g_signal_connect(G_OBJECT(params->query_entry), "size-allocate", (GCallback)query_entry_size_allocate, explanation_label);
	gtk_container_add(GTK_CONTAINER(vbox), explanation_label);

	params->trr = NULL;
	params->row_changed_signal_id = 0;
	params->row_deleted_signal_id = 0;

	if (!itr)
		set_new_query(params);
	else {
		GtkTreePath *tp = gtk_tree_model_get_path(tm, itr);

		if (tp) {
			params->trr = gtk_tree_row_reference_new(tm, tp);
			if (params->trr) {
				params->row_deleted_signal_id = g_signal_connect(G_OBJECT(tm), "row-deleted", (GCallback)tm_row_deleted, params);
//				params->row_changed_signal_id = g_signal_connect(G_OBJECT(tm), "row-changed", (GCallback)tm_row_changed, params);
			}
			gtk_tree_path_free(tp); tp = NULL;
		}

		set_from_iter(params, tm, itr);
	}

	gtk_dialog_run(GTK_DIALOG(params->dlg));
}
