#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "pogacsa.h"
#include "add-edit-query-dialog.h"
#include "query-dialog.h"
#include "intl.h"

enum {
	SETTINGS_ADD_QUERY = 1,
	SETTINGS_EDIT_QUERY,
	SETTINGS_DELETE_QUERY,
	SETTINGS_RAISE_QUERY,
	SETTINGS_LOWER_QUERY
};

struct _PogacsaHomePlugin {
	HDHomePluginItem __parent_instance__;

	GtkTreeModel *tm;
};

struct _PogacsaHomePluginClass {
	HDHomePluginItemClass __parent_class__;
};

HD_DEFINE_PLUGIN_MODULE(PogacsaHomePlugin, pogacsa_home_plugin, HD_TYPE_HOME_PLUGIN_ITEM);

static void
pogacsa_home_plugin_class_finalize(PogacsaHomePluginClass *klass)
{
}

static void
realize(GtkWidget *widget)
{
  GdkScreen *screen = gtk_widget_get_screen (widget);
  gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));
  gtk_widget_set_app_paintable (widget, TRUE);

	if (GTK_WIDGET_CLASS (pogacsa_home_plugin_parent_class)->realize)
	  GTK_WIDGET_CLASS (pogacsa_home_plugin_parent_class)->realize (widget);
}

static gboolean
expose_event(GtkWidget *widget, GdkEventExpose *event)
{
  cairo_t *cr;

  cr = gdk_cairo_create(GDK_DRAWABLE(widget->window));
  gdk_cairo_region(cr, event->region);
  cairo_clip(cr);
  cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
  cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.0);
  cairo_paint (cr);
  
  cairo_destroy (cr);

  return GTK_WIDGET_CLASS (pogacsa_home_plugin_parent_class)->expose_event ?
		GTK_WIDGET_CLASS (pogacsa_home_plugin_parent_class)->expose_event (widget, event) : FALSE;
}

typedef struct {
	GtkTreeModel *tm;
	guint row_inserted_id;
	guint row_deleted_id;
	guint rows_reordered_id;
	GtkWidget *label;
	GtkWidget *dlg;
	GtkWidget *tv;
	GtkWidget *edit_button;
	GtkWidget *raise_button;
	GtkWidget *lower_button;
	GtkWidget *delete_button;
	GtkTreeSelection *ts;
} SettingsDialogParams;

static void
settings_dialog_response(GtkWidget *dlg, gint response_id, SettingsDialogParams *sdp)
{
	if (response_id >= 0) {
		if (SETTINGS_ADD_QUERY == response_id) {
			add_edit_query_dialog_run(dlg, gtk_tree_view_get_model(GTK_TREE_VIEW(sdp->tv)), NULL);
			return;
		}
		else {
			GtkTreeModel *tm;
			GtkTreeIter itr;

			if (gtk_tree_selection_get_selected(sdp->ts, &tm, &itr)) {

				if (SETTINGS_EDIT_QUERY == response_id)
					add_edit_query_dialog_run(dlg, tm, &itr);
				else
				if (SETTINGS_DELETE_QUERY == response_id)
					query_tree_model_delete(tm, &itr);
				else
				if (SETTINGS_RAISE_QUERY == response_id)
					query_tree_model_move(tm, &itr, TRUE);
				else
				if (SETTINGS_LOWER_QUERY == response_id)
					query_tree_model_move(tm, &itr, FALSE);

				return;
			}
		}
	}
	gtk_widget_hide(dlg);
	gtk_widget_destroy(dlg);
}

static void
tv_row_activated(GtkTreeView *tv, GtkTreePath *tp, GtkTreeViewColumn *col, GtkTreeModel *tm)
{
	GtkTreeIter itr;

	if (gtk_tree_model_get_iter(tm, &itr, tp))
		add_edit_query_dialog_run(gtk_widget_get_toplevel(GTK_WIDGET(tv)), tm, &itr);
}

static void
ts_changed(SettingsDialogParams *sdp)
{
	
	GtkTreeIter itr;
	GtkTreeModel *tm;
	gboolean has_sel = gtk_tree_selection_get_selected(sdp->ts, &tm, &itr);
	gboolean has_prev = TRUE, has_next = TRUE;

	if (has_sel) {
		GtkTreePath *tp = gtk_tree_model_get_path(tm, &itr);
		if (tp) {
			has_prev = (gtk_tree_path_get_indices(tp)[0] != 0);
			gtk_tree_path_free(tp);
		}

		has_next = gtk_tree_model_iter_next(tm, &itr);
	}

	g_object_set(G_OBJECT(sdp->edit_button),   "sensitive", has_sel,             NULL);
	g_object_set(G_OBJECT(sdp->raise_button),  "sensitive", has_sel && has_prev, NULL);
	g_object_set(G_OBJECT(sdp->lower_button),  "sensitive", has_sel && has_next, NULL);
	g_object_set(G_OBJECT(sdp->delete_button), "sensitive", has_sel,             NULL);
}

static void
remove_ids_and_free(SettingsDialogParams *sdp)
{
	g_signal_handler_disconnect(sdp->tm, sdp->row_inserted_id);
	g_signal_handler_disconnect(sdp->tm, sdp->row_deleted_id);
	g_signal_handler_disconnect(sdp->tm, sdp->rows_reordered_id);
	g_free(sdp);
}

static void
show_settings(PogacsaHomePlugin *pogacsa_home_plugin)
{
	GtkWidget *query_tv = NULL;
	SettingsDialogParams *sdp = g_new0(SettingsDialogParams, 1);

	sdp->tm = pogacsa_home_plugin->tm;
	sdp->dlg = gtk_dialog_new_with_buttons(_("Queries"), NULL, 0,
		GTK_STOCK_ADD, SETTINGS_ADD_QUERY,
		NULL);
	sdp->edit_button   = gtk_dialog_add_button(GTK_DIALOG(sdp->dlg), GTK_STOCK_EDIT,    SETTINGS_EDIT_QUERY);
	sdp->raise_button  = gtk_dialog_add_button(GTK_DIALOG(sdp->dlg), GTK_STOCK_GO_UP,   SETTINGS_RAISE_QUERY);
	sdp->lower_button  = gtk_dialog_add_button(GTK_DIALOG(sdp->dlg), GTK_STOCK_GO_DOWN, SETTINGS_LOWER_QUERY);
	sdp->delete_button = gtk_dialog_add_button(GTK_DIALOG(sdp->dlg), GTK_STOCK_DELETE,  SETTINGS_DELETE_QUERY);
	g_object_set_data_full(G_OBJECT(sdp->dlg), "sdp", sdp, (GDestroyNotify)remove_ids_and_free);

	gtk_widget_set_size_request(sdp->dlg, -1, 420);

	query_tv = query_dialog_make_tv(pogacsa_home_plugin->tm, &(sdp->tv));
	sdp->ts = gtk_tree_view_get_selection(GTK_TREE_VIEW(sdp->tv));
	g_object_set(G_OBJECT(sdp->tv), "hildon-ui-mode", HILDON_UI_MODE_EDIT, NULL);
	gtk_tree_selection_set_mode(sdp->ts, GTK_SELECTION_BROWSE);

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(sdp->dlg)->vbox), query_tv);

	g_signal_connect(G_OBJECT(sdp->tv), "row-activated", (GCallback)tv_row_activated, pogacsa_home_plugin->tm);
	g_signal_connect_swapped(G_OBJECT(sdp->ts), "changed", (GCallback)ts_changed, sdp);
	sdp->row_inserted_id   = g_signal_connect_swapped(G_OBJECT(pogacsa_home_plugin->tm), "row-inserted",   (GCallback)ts_changed, sdp);
	sdp->row_deleted_id    = g_signal_connect_swapped(G_OBJECT(pogacsa_home_plugin->tm), "row-deleted",    (GCallback)ts_changed, sdp);
	sdp->rows_reordered_id = g_signal_connect_swapped(G_OBJECT(pogacsa_home_plugin->tm), "rows-reordered", (GCallback)ts_changed, sdp);
	ts_changed(sdp);

	g_signal_connect(G_OBJECT(sdp->dlg), "response", (GCallback)settings_dialog_response, sdp);

	gtk_widget_show(sdp->dlg);
}

static gboolean
button_release_event(GtkWidget *widget, GdkEventButton *event)
{
	if (1 == event->button) {
		query_dialog_show(HD_HOME_PLUGIN_ITEM(widget), POGACSA_HOME_PLUGIN(widget)->tm);
	}

  return GTK_WIDGET_CLASS (pogacsa_home_plugin_parent_class)->button_release_event ?
		GTK_WIDGET_CLASS (pogacsa_home_plugin_parent_class)->button_release_event (widget, event) : FALSE;
}

static void
pogacsa_home_plugin_class_init(PogacsaHomePluginClass *klass)
{
	GtkWidgetClass *gtkwidget_class = GTK_WIDGET_CLASS(klass);

	gtkwidget_class->realize              = realize;
	gtkwidget_class->expose_event         = expose_event;
	gtkwidget_class->button_release_event = button_release_event;
}

static void
pogacsa_home_plugin_init(PogacsaHomePlugin *pogacsa_home_plugin)
{
	pogacsa_home_plugin->tm = query_tree_model_new();
	g_object_set(G_OBJECT(pogacsa_home_plugin), "settings", TRUE, NULL);

	g_signal_connect(G_OBJECT(pogacsa_home_plugin), "show-settings", (GCallback)show_settings, NULL);
	gtk_container_add(GTK_CONTAINER(pogacsa_home_plugin),
		g_object_new(GTK_TYPE_IMAGE, "visible", TRUE, "file", "/usr/share/icons/hicolor/128x128/hildon/pogacsa.png", NULL));
}

#ifdef RUN_STANDALONE

static gboolean
stuff_on_stdin(GIOChannel *gio_stdin, GIOCondition *cond, PogacsaHomePlugin *wqhp)
{
	char *str = NULL;

	if (G_IO_STATUS_NORMAL == g_io_channel_read_line(gio_stdin, &str, NULL, NULL, NULL))
		if (str) {
			if (!g_strcmp0(str, "quit\n"))
				gtk_main_quit();
			else
			if (!g_strcmp0(str, "show\n"))
				show_settings(wqhp);
			g_free(str);
		}
	return TRUE;
}

int
main(int argc, char **argv)
{
	GIOChannel *chan = NULL;
	PogacsaHomePlugin *wqhp = g_new0(PogacsaHomePlugin, 1);

	hildon_gtk_init(&argc, &argv);

	wqhp->tm = query_tree_model_new();

	chan = g_io_channel_unix_new(0);
	g_io_add_watch(chan, G_IO_IN, (GIOFunc)stuff_on_stdin, wqhp);

	gtk_main();

	g_free(wqhp);

	g_io_channel_unref(chan);

	return 0;
}
#endif /* RUN_STANDALONE */
