// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef PLANS_PLANT_TREE_WIDGETS_HPP
#define PLANS_PLANT_TREE_WIDGETS_HPP
#include <QAbstractItemModel>
#include <QTreeView>
#include "tasks.hpp"
#ifdef Q_WS_MAEMO_5
#define PLANSPLANT_HANDHELD
#endif // Q_WS_MAEMO_5
#define PLANSPLANT_TIME_LIST_NO_INDENT
namespace PlansPlant
{
#if 0
  class PLANSPLANT_CLASS TasksActionsBlock : public QObject
  {
  public:
    TasksActionsBlock( QObject* Parent = 0 );
    void switch_destination( QObject* NewDestination );
    // Get menu actions of this tree
    QAction* task_add_action() const { return TaskAddAction; }
    QAction* task_edit_action() const { return TaskEditAction; }
    QAction* task_delete_action() const { return TaskDeleteAction; }
    QAction* dependency_add_action() const { return DependencyAddAction; }
    QAction* dependency_change_action() const { return DependencyChangeAction; }
    QAction* dependency_remove_action() const { return DependencyRemoveAction; }
    QAction* move_up_action() const { return MoveUpAction; }
    QAction* move_down_action() const { return MoveDownAction; }
  protected:
    QAction* TaskAddAction;
    QAction* TaskEditAction;
    QAction* TaskDeleteAction;
    QAction* DependencyAddAction;
    QAction* DependencyChangeAction;
    QAction* DependencyRemoveAction;
    QAction* MoveUpAction;
    QAction* MoveDownAction;
  }; // TasksTreeActionsBlock
#endif
  class PLANSPLANT_CLASS TasksModel : public QAbstractItemModel, public Task::Watcher
  {
    Q_OBJECT
  public:
    class PLANSPLANT_CLASS Item
    {
    public:
      typedef Item* Pointer;
      typedef QList<Pointer> List;
      enum Relation { Unknown, Subtask, Blocker };
      virtual ~Item();
      virtual Task* task() const { return 0; }
      virtual QVariant data( int Column, int Role = Qt::DisplayRole ) const;
      virtual Pointer parent() const { return 0; }
      virtual bool is_leaf() const { return subitems().empty(); }
      virtual int relation() const { return Unknown; }
      virtual const List& subitems() const { return SubItems; }
      virtual List& subitems() { return SubItems; }
      virtual Item* subitem( int Index ) const { return SubItems[ Index ]; }
      virtual bool populated() const { return is_leaf() || !subitems().empty(); } 
      virtual bool indent() const { return true; } //!< Indent _next_ line.
      virtual void populate() {}
      virtual bool move_subitem( int From, int To );
      // Update notifications from the model
      virtual void task_added( Task& NewTask, TasksModel& Model );
      virtual void task_removed( Task::ID TaskID, TasksModel& Model );
      virtual void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
      virtual void task_moved( const Task& MovedTask, int OldIndex, int NewIndex, TasksModel& Model );
      virtual void blocker_added( const Task& Dependant, Task& NewBlocker, TasksModel& Model );
      virtual void blocker_removed( const Task& Dependant, const Task& OldBlocker, TasksModel& Model );
      virtual void blocker_moved( const Task& Dependant, const Task& Blocker, int OldIndex, int NewIndex, TasksModel& Model );
      virtual void blockers_replaced( const Task& Dependant, TasksModel& Model );
    protected:
      // Helpers
      void add_subitem( Item& NewSubItem, TasksModel& Model, int Place = -1 );
      void remove_subitem( int Index, TasksModel& Model );
      void move_subitem( int From, int To, TasksModel& Model );
      Item::List SubItems;
    }; // Item
    class Items
    {
    public:
      class PLANSPLANT_CLASS TaskItem : public Item
      {
      public:
	typedef TaskItem* Pointer;
	typedef QList<Pointer> List;
	static TaskItem::Pointer downcast( Item::Pointer This ) { return static_cast<TaskItem::Pointer>( This ); }
	TaskItem( Task& Object0 ) : Object( Object0 ) {}
	Task* task() const { return &Object; }
	QVariant data( int Column, int Role = Qt::DisplayRole ) const;
	bool is_leaf() const;
	void populate();
	// Update notifications from the model
	void task_added( Task& NewTask, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
	void task_moved( const Task& MovedTask, int OldIndex, int NewIndex, TasksModel& Model );
	void blocker_added( const Task& Dependant, Task& NewBlocker, TasksModel& Model );
	void blocker_removed( const Task& Dependant, const Task& OldBlocker, TasksModel& Model );
	void blocker_moved( const Task& Dependant, const Task& Blocker, int OldIndex, int NewIndex, TasksModel& Model );
	void blockers_replaced( const Task& Dependant, TasksModel& Model );
      protected:
	Task& Object;
      }; // TaskItem
      class PLANSPLANT_CLASS RootItem : public Item
      {
      public:
	typedef RootItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<RootItem::Pointer>( This ); }
	RootItem( TasksFile& File0 ) : File( File0 ) {}
	bool indent() const { return false; }
      protected:
	TasksFile& File;
      }; // RootItem
      class PLANSPLANT_CLASS SubtaskItem : public TaskItem
      {
      public:
	typedef SubtaskItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	SubtaskItem( TaskItem& Parent0, Task& Object0 ) : TaskItem( Object0 ), Parent( Parent0 ) {}
	int relation() const { return Subtask; }
	Item::Pointer parent() const;
      protected:
	TaskItem& Parent;
      }; // SubtaskItem
      class PLANSPLANT_CLASS BlockerItem : public SubtaskItem
      {
      public:
	typedef BlockerItem* Pointer;
	typedef QList<Pointer> List;
	static BlockerItem::Pointer downcast( Item::Pointer This ) { return static_cast<BlockerItem::Pointer>( This ); }
	BlockerItem( TaskItem& Parent0, Task& Object0 ) : SubtaskItem( Parent0, Object0 ) {}
	int relation() const { return Blocker; }
	QVariant data( int Column, int Role = Qt::DisplayRole ) const;
      }; // BlockerItem
      class PLANSPLANT_CLASS SpecialItem : public Item
      {
      public:
	typedef SpecialItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	SpecialItem( Item& Parent0, const QString& Name0, const QColor& Color0 = QColor( Qt::black ) ) : Parent( Parent0 ), Name( Name0 ), Color( Color0 ) {}
	QVariant data( int Column, int Role = Qt::DisplayRole ) const;
	TaskItem::Pointer task( int Index ) const;
	Item::Pointer parent() const { return &Parent; }
	virtual void add( Task& Tsk );
	bool indent() const { return false; }
      protected:
	Item& Parent;
	QString Name;
	QColor Color;
      }; // SpecialItem
      class PLANSPLANT_CLASS SpecialTaskItem : public TaskItem
      {
      public:
	typedef SpecialTaskItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	SpecialTaskItem( SpecialItem& Parent0, Task& Object0 ) : TaskItem( Object0 ), Parent( Parent0 ) {}
	Item::Pointer parent() const;
      protected:
	SpecialItem& Parent;
      }; // SpecialTaskItem
    }; // Items
    enum ColumnNum { NameCol, CompletedMarkCol, PriorityIconCol, CompletedCol, PlanStartCol, PlanFinishCol, EstimationCol, ElapsedCol, DescriptionCol, CommentCol, TotalCols = DescriptionCol };
    TasksModel( TasksFile& File0, QObject* Parent = 0 );
    ~TasksModel();
    TasksFile& file() const { return File; }
    Item* item_from_index( const QModelIndex& Index ) const;
    Task* task_from_index( const QModelIndex& Index ) const;
    Item* root() const { return Root; }
    //! \todo void root( Item& NewRoot );
    QModelIndex index( Item& ForItem, int Column = 0 ) const;
    bool is_subtask( const QModelIndex& Index ) const;
    bool is_blocker( const QModelIndex& Index ) const;
    // QAbstractItemModel overloads
    bool hasChildren( const QModelIndex & Parent = QModelIndex() ) const;
    int rowCount( const QModelIndex& Parent = QModelIndex() ) const;
    int columnCount( const QModelIndex& Parent = QModelIndex() ) const;
    bool canFetchMore( const QModelIndex& Parent ) const;
    void fetchMore( const QModelIndex& Parent );
    QModelIndex index( int Row, int Column, const QModelIndex& Parent = QModelIndex() ) const;
    QModelIndex parent( const QModelIndex& Index ) const;

    QVariant data( const QModelIndex& Index, int Role = Qt::DisplayRole ) const;
    QVariant headerData( int Section, Qt::Orientation Orient, int Role = Qt::DisplayRole ) const;
    // Prepare the tree widget
    virtual void resize_columns( QTreeView* Tree ) const;
    // Operations
    virtual void add_task( const QModelIndex& Parent, QWidget* Widget = 0 );
    virtual void open_task( const QModelIndex& Index, QWidget* Widget = 0 );
    virtual void delete_task( const QModelIndex& Index, QWidget* Widget = 0 );
    virtual void add_blocker( const QModelIndex& Index, QWidget* Widget = 0 );
    virtual void edit_blockers( const QModelIndex& Index, QWidget* Widget = 0 );
    virtual void remove_blocker( const QModelIndex& Index, QWidget* Widget = 0 );
    virtual void move_item( const QModelIndex& Index, int Distance = 1, QWidget* Widget = 0 );
    virtual void item_clicked( const QModelIndex& Index, QWidget* Widget = 0 );
  protected:
    // Callbacks from informers
    void file_closed( TasksFile& ClosedFile );
    void task_added( Task& NewTask );
    void task_removed( Task::ID TaskID );
    void task_changed( Task& Object, Task::Change::FieldID Field );
    void task_moved( const Task& Object, int OldIndex, int NewIndex );
    void blocker_added( const Task& Object, Task& NewBlocker );
    void blocker_removed( const Task& Object, const Task& OldBlocker );
    void blocker_moved( const Task& Object, const Task& Blocker, int OldIndex, int NewIndex );
    void blockers_replaced( const Task& Dependant );
    Item* Root;
    TasksFile& File;
  }; // TasksModel

  class PLANSPLANT_CLASS TasksTreeModel : public TasksModel
  { //! \todo Populate incrementally
    Q_OBJECT      
  public:
    class Items : public TasksModel::Items
    {
    public:
      class PLANSPLANT_CLASS TasksRootItem : public RootItem
      {
      public:
	typedef TasksRootItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	TasksRootItem( TasksFile& File0 ) : RootItem( File0 ) {}
	bool is_leaf() const;
	void populate();
	void task_added( Task& NewTask, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
	void task_moved( const Task& MovedTask, int OldIndex, int NewIndex, TasksModel& Model );
      }; // TasksRootItem
      class PLANSPLANT_CLASS RootTaskItem : public TaskItem
      {
      public:
	typedef RootTaskItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	RootTaskItem( RootItem& Parent0, Task& Object0 ) : TaskItem( Object0 ), Parent( Parent0 ) {}
	int relation() const { return Subtask; }
	Item::Pointer parent() const;
      protected:
	RootItem& Parent;
      }; // RootTaskItem
    }; // Items
  public:
    TasksTreeModel( TasksFile& File0, QObject* Parent = 0 );
#ifdef PLANSPLANT_NEED_OLD_OPERATIONS
    // !! Old operations
    bool move_task( const QModelIndex& Index, int From, int To );
    void remove_blocker( const QModelIndex& Index );
#endif // PLANSPLANT_NEED_OLD_OPERATIONS
  }; // TasksTreeModel;

  class PLANSPLANT_CLASS TasksTimeListModel : public TasksModel
  {
  public:
    class Items : public TasksModel::Items
    {
    public:
      class YearItem;
      class MonthItem;
      class DayItem;
      class PLANSPLANT_CLASS NoTimeItem : public SpecialItem
      {
      public:
	typedef NoTimeItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	NoTimeItem( Item& Parent0 ) : SpecialItem( Parent0, tr( "Without time" ), QColor( 180, 128, 0 ) ) {}
	void task_added( Task& NewTask, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
	void add( Task& Tsk );
      }; // NoTimeItem
      class PLANSPLANT_CLASS OverdueItem : public SpecialItem
      {
      public:
	typedef OverdueItem* Pointer;
	typedef QList<Pointer> List;
	static OverdueItem::Pointer downcast( Item::Pointer This ) { return static_cast<OverdueItem::Pointer>( This ); }
	OverdueItem( Item& Parent0 );
	void task_added( Task& NewTask, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
	void add( Task& Tsk );
      protected:
	QDateTime TimeStamp;
      }; // OverdueItem
      class PLANSPLANT_CLASS DayTaskItem : public TaskItem
      {
      public:
	typedef DayTaskItem* Pointer;
	typedef QList<Pointer> List;
	static DayTaskItem::Pointer downcast( Item::Pointer This ) { return static_cast<DayTaskItem::Pointer>( This ); }
	DayTaskItem( DayItem& Day0, Task& Object0 ) : TaskItem( Object0 ), Day( Day0 ) {}
	int relation() const { return Unknown; } //!< \todo See TaskItem
	QVariant data( int Column, int Role ) const;
	Item* parent() const;
	DayItem& day() const;
      protected:
	DayItem& Day;
      }; // DayTaskItem
      class PLANSPLANT_CLASS DayItem : public Item
      {
      public:
	typedef DayItem* Pointer;
	typedef QList<Pointer> List;
	static DayItem::Pointer downcast( Item::Pointer This ) { return static_cast<DayItem::Pointer>( This ); }
	DayItem( MonthItem& Month0, short Day0 ) : Day( Day0 ), Month( Month0 ) {}
	QVariant data( int Column, int Role = Qt::DisplayRole ) const;
	Item::Pointer parent() const;
	QDate date() const;
	int day() const { return Day; }
	MonthItem& month() const { return Month; }
	DayTaskItem::Pointer task( int Index ) const;
	void add( Task& Tsk, TasksModel* Model = 0 );
	bool indent() const { return false; }
	void task_added( Task& NewTask, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
      protected:
	short Day;
	MonthItem& Month;
      }; // DayItem
      class PLANSPLANT_CLASS MonthItem : public Item
      {
      public:
	typedef MonthItem* Pointer;
	typedef QList<Pointer> List;
	static MonthItem::Pointer downcast( Item::Pointer This ) { return static_cast<MonthItem::Pointer>( This ); }
	MonthItem( YearItem& Year0, short Month0 ) : Month( Month0 ), Year( Year0 ) {}
	QVariant data( int Column, int Role = Qt::DisplayRole ) const;
	Item::Pointer parent() const;
	YearItem& year() const { return Year; }
	int month() const { return Month; }
	DayItem::Pointer day( int Index ) const;
	void add( Task& Tsk, TasksModel* Model = 0 );
	bool indent() const { return false; }
	void task_added( Task& NewTask, TasksModel& Model );
	void task_removed( Task::ID TaskID, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
      private:
	void add_day_item( Task& DayTask, int Day, int Place, TasksModel& Model );
      protected:
	short Month;
	YearItem& Year;
      }; // MonthItem
      class PLANSPLANT_CLASS YearItem : public Item
      {
      public:
	typedef YearItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	YearItem( Item& Parent0, short Year0 ) : Year( Year0 ), Parent( Parent0 ) {}
	QVariant data( int Column, int Role = Qt::DisplayRole ) const;
	int year() const { return Year; }
	MonthItem::Pointer month( int Index ) const;
	Item::Pointer parent() const;
	void add( Task& Tsk, TasksModel* Model = 0 );
	bool indent() const { return false; }
	void task_added( Task& NewTask, TasksModel& Model );
	void task_removed( Task::ID TaskID, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
      private:
	void add_month_item( Task& MonthTask, int Month, int Place, TasksModel& Model );
      protected:
	short Year;
	Item& Parent;
      }; // YearItem
      class PLANSPLANT_CLASS TimesRootItem : public RootItem
      {
      public:
	typedef TimesRootItem* Pointer;
	typedef QList<Pointer> List;
	static Pointer downcast( Item::Pointer This ) { return static_cast<Pointer>( This ); }
	TimesRootItem( TasksFile& File0 ) : RootItem( File0 ) {}
	bool is_leaf() const;
	void populate();
	void add( Task& Tsk, TasksModel* Model = 0 );
	void add_branch( Task& Root );
	void task_added( Task& NewTask, TasksModel& Model );
	void task_removed( Task::ID TaskID, TasksModel& Model );
	void task_changed( Task& ChangedTask, Task::Change::FieldID Field, TasksModel& Model );
      private:
	void add_year_item( Task& YearTask, int Year, int Place, TasksModel& Model );
      protected:
	YearItem::List Years;
	SpecialItem::List Specials;
      }; // TimesRootItem
    }; // Items
  public:
    TasksTimeListModel( TasksFile& File0, QObject* Parent = 0 );
  protected:
    static void min_max_for_date( const Task& T, const QDate& Date, QDateTime& Min, QDateTime& Max );
    static int compare( const Task& Task1, const Task& Task2, const QDate& Date );
    Items::YearItem::List Roots;
    Items::SpecialItem::List Specials;
  }; // TasksTimeListModel

  class PLANSPLANT_CLASS TasksTreeWidget : public QTreeView
  {
    Q_OBJECT
  public:
    TasksTreeWidget( QWidget* Parent = 0, TasksModel* Model0 = 0 );
    QSize sizeHint() const;
    TasksModel* tasks() { return static_cast<TasksModel*>( model() ); } //! \todo Change to qobject_cast.
    void tasks( TasksModel* Tasks );
    QModelIndex selected_index() const;
    TasksModel::Item* selected_item() { return tasks() ? tasks()->item_from_index( selected_index() ) : 0; }
    Task* selected_task() { return tasks() ? tasks()->task_from_index( selected_index() ) : 0; }
    bool select_task( const Task* NewCurrent = 0 );
    // Get menu actions of this tree
    QAction* task_add_action() const { return TaskAddAction; }
    QAction* task_edit_action() const { return TaskEditAction; }
    QAction* task_delete_action() const { return TaskDeleteAction; }
    QAction* dependency_add_action() const { return DependencyAddAction; }
    QAction* dependencies_edit_action() const { return DependenciesEditAction; }
    QAction* dependency_remove_action() const { return DependencyRemoveAction; }
    QAction* move_up_action() const { return MoveUpAction; }
    QAction* move_down_action() const { return MoveDownAction; }
  public slots:
    // Commands from actions (redirects to the model).
    void add_task();
    void open_task();
    void delete_task();
    void add_blocker();
    void edit_blockers();
    void remove_blocker();
    void move_up();
    void move_down();
    void item_clicked( const QModelIndex& Index );
    void selection_changed( const QItemSelection& New );
    void selection_changed( const QModelIndex& NewIndex );
  protected:
    QAction* TaskAddAction;
    QAction* TaskEditAction;
    QAction* TaskDeleteAction;
    QAction* DependencyAddAction;
    QAction* DependenciesEditAction;
    QAction* DependencyRemoveAction;
    QAction* MoveUpAction;
    QAction* MoveDownAction;
  }; // TasksTreeWidget

  class PLANSPLANT_CLASS TasksTimeListWidget : public TasksTreeWidget
  {
  public:
    TasksTimeListWidget( QWidget* Parent = 0, TasksModel* Model0 = 0 ) : TasksTreeWidget( Parent, Model0 ) {}
  protected:
#ifdef PLANSPLANT_TIME_LIST_NO_INDENT
    bool span( const QModelIndex& Index ) const;
    int indent( const QModelIndex& Ind ) const;
    void drawRow( QPainter* Painter, const QStyleOptionViewItem& Option, const QModelIndex& Index ) const;
    void mousePressEvent( QMouseEvent* Event );
    bool expand_collapse( const QPoint& Pos );
#endif // PLANSPLANT_TIME_LIST_NO_INDENT
  }; // TasksTimeListWidget
} // PlansPlant
#endif // PLANS_PLANT_TREE_WIDGETS_HPP
