// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#include <timeshop.hpp>
#include "plansplant/events.hpp"
#include <QDebug>

namespace PlansPlant
{
  Task::Watcher::Events::TaskAdded* Task::Watcher::Events::TaskAdded::load( QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    TaskAdded* Result = 0;
    Task* Tsk = 0;
    Event::ID EventID = Stream.attributes().value( "id" ).toString();
    qDebug() << "Loading task:" << EventID.str();
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
    {
      qDebug() << Stream.name();
      if( Stream.name() == "task" )
      {
	Tsk = new Task;
	qDebug() << "Loading task";
	Tsk->load( Stream, Tasks );
      }
      else if( Stream.name() == "blockers" )
      {
	while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
	  if( Stream.name() == "blocker" )
	    if( Task* Blocker = Tasks.find_task( Stream.readElementText() ) )
	      Tsk->add_blocker( *Blocker );
      }
      else
	Timeshop::Persistent::Loader::skip( Stream );
    }
    if( Tsk )
      Result = new TaskAdded( *Tsk, EventID );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Watcher::Events::TaskAdded::TaskAdded( Task& Object0, ID Ident0 ) : Event( Ident0 ), Object( Object0 ) {} // TaskAdded( Task&, ID )
  Task::Watcher::Event::Type Task::Watcher::Events::TaskAdded::type() const { return Event::TaskAdded; }
  void Task::Watcher::Events::TaskAdded::apply( TasksFile& Tasks ) const { Tasks.add_task( Object, this ); }
  void Task::Watcher::Events::TaskAdded::inform( Task::Watcher& Dest ) const { Dest.task_added( Object ); }
  void Task::Watcher::Events::TaskAdded::write_fields( QXmlStreamWriter& Stream ) const
  {
    Object.write( Stream, true );
    Object.write_blockers( Stream );
  } // write_fields( QXmlStreamWriter& ) const
    
  Task::Watcher::Events::TaskRemoved* Task::Watcher::Events::TaskRemoved::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    TaskRemoved* Result = 0;
    Event::ID EventID = Stream.attributes().value( "id" ).toString();
    Task::ID ObjectID;
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
    {
      qDebug() << "TaskRemoved:" << Stream.name();
      if( Stream.name() == "task_id" )
	ObjectID = Stream.readElementText();
      else
	Timeshop::Persistent::Loader::skip( Stream );
    }
    if( EventID.valid() && ObjectID.valid() )
      Result = new TaskRemoved( ObjectID, EventID );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Watcher::Events::TaskRemoved::TaskRemoved( Task& Object0, ID Ident0 ) : Event( Ident0 ), TaskID( Object0.id() ) {} // TaskRemoved( Task&, ID )
  Task::Watcher::Events::TaskRemoved::TaskRemoved( Task::ID ObjectID0, ID Ident0 ) : Event( Ident0 ), TaskID( ObjectID0 ) {} // TaskRemoved( Task::ID, ID )
  Task::Watcher::Event::Type Task::Watcher::Events::TaskRemoved::type() const { return Event::TaskRemoved; }
  void Task::Watcher::Events::TaskRemoved::apply( TasksFile& Tasks ) const
  {
    if( Task* TaskToDelete = Tasks.find_task( TaskID ) )
      Tasks.delete_task( *TaskToDelete, this );
  } // apply( TasksFile& ) const
  void Task::Watcher::Events::TaskRemoved::inform( Task::Watcher& Dest ) const { Dest.task_removed( TaskID ); }
  void Task::Watcher::Events::TaskRemoved::write_fields( QXmlStreamWriter& Stream ) const { Stream.writeTextElement( "task_id", TaskID ); }

  Task::Watcher::Events::TaskChanged* Task::Watcher::Events::TaskChanged::load( QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    TaskChanged* Result = 0;
    Event::ID EventID = Stream.attributes().value( "id" ).toString();
    if( EventID.valid() && Timeshop::Persistent::Loader::next_subelement( Stream ) && Stream.name() == "changes_list" )
      if( Task::ID TaskID = Stream.attributes().value( "task_id" ).toString() )
      {
	if( Task* Object = Tasks.find_task( TaskID ) )
	{
	  Task::ChangesList* NewChanges = new ChangesList( *Object );
	  if( NewChanges->load( Stream, Tasks ) )
	    Result = new TaskChanged( NewChanges, EventID );
	  else
	    delete NewChanges;
	}
	else qDebug() << "Changed task with id" << TaskID.str() << "not found.";
      }
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Watcher::Events::TaskChanged::TaskChanged( Task::ChangesList* Changes0, ID Ident0 ) : Event( Ident0 ), Changes( Changes0 ) {} // TaskChanged( Task::ChangesList&, ID )
  Task::Watcher::Event::Type Task::Watcher::Events::TaskChanged::type() const { return Event::TaskChanged; }
  void Task::Watcher::Events::TaskChanged::apply( TasksFile& Tasks ) const
  {
    Tasks.change_task( *Changes, this );
  } // apply( TasksFile& ) const
  void Task::Watcher::Events::TaskChanged::inform( Task::Watcher& Dest ) const { if( Changes ) Dest.task_changed( *Changes ); }
  void Task::Watcher::Events::TaskChanged::write_fields( QXmlStreamWriter& Stream ) const { if( Changes ) Changes->write( Stream ); }

  Task::Watcher::Events::RootTaskMoved* Task::Watcher::Events::RootTaskMoved::load( QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    RootTaskMoved* Result = 0;
    Event::ID EventID = Stream.attributes().value( "id" ).toString();
    Task::ID ObjectID;
    int F = 0;
    int T = 0;
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
    {
      if( Stream.name() == "task_id" )	 ObjectID = Stream.readElementText();
      else if( Stream.name() == "from" ) F = Stream.readElementText().toInt();
      else if( Stream.name() == "to" )	 T = Stream.readElementText().toInt();
      else				 Timeshop::Persistent::Loader::skip( Stream );
    }
    if( EventID.valid() && ObjectID.valid() )
    {
      if( Task* Obj = Tasks.find_task( ObjectID ) )
	Result = new RootTaskMoved( *Obj, F, T, EventID );
      else qDebug() << "Moved root task with id" << ObjectID.str() << "not found.";
    }
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Watcher::Events::RootTaskMoved::RootTaskMoved( Task& Object0, int From0, int To0, ID Ident0 ) : Event( Ident0 ), Object( Object0 ), From( From0 ), To( To0 ) {}
  Task::Watcher::Event::Type Task::Watcher::Events::RootTaskMoved::type() const { return Event::RootTaskMoved; }
  void Task::Watcher::Events::RootTaskMoved::apply( TasksFile& Tasks ) const
  {
    Tasks.move_task( Object, From, To, this );
  } // apply( TasksFile& ) const
  void Task::Watcher::Events::RootTaskMoved::inform( Task::Watcher& Dest ) const { Dest.task_moved( Object, From, To ); }
  void Task::Watcher::Events::RootTaskMoved::write_fields( QXmlStreamWriter& Stream ) const
  {
    Stream.writeTextElement( "task_id", Object.id() );
    Stream.writeTextElement( "from", QString::number( From ) );
    Stream.writeTextElement( "to", QString::number( To ) );
  } // write_fields( QXmlStreamWriter& ) const
} // PlansPlant
