//
// directvprotocol.h
//
// Copyright 2012 - 2015 by John Pietrzak (jpietrzak8@gmail.com)
//
// This file is part of Pierogi.
//
// Pierogi is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Pierogi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//

#ifndef DIRECTVPROTOCOL_H
#define DIRECTVPROTOCOL_H

#include "pirprotocol.h"

class PIRInfraredLED;

enum DirectvGapSize
{
  ShortGap_Directv,
  LongGap_Directv
};

enum DirectvFreq
{
  LowFreq_Directv,
  MediumFreq_Directv,
  HighFreq_Directv
};

class DirectvProtocol: public PIRProtocol
{
  Q_OBJECT

public:
  DirectvProtocol(
    QObject *guiObject,
    unsigned int index);

  void setProtocolParms(
    DirectvGapSize gap,
    DirectvFreq freq);

private:
  void startSendingCommand(
    unsigned int threadableID,
    PIRKeyName command);

  int generateStandardCommand(
    const PIRKeyBits &pkb,
    PIRInfraredLED &led);

  int pushDTVBits(
    const CommandSequence &bits,
    PIRInfraredLED &led);

  void generateChecksum(
    const CommandSequence &bits,
    CommandSequence &checksumBits);
};

#endif // DIRECTVPROTOCOL_H
