#include <hildon/hildon.h>

static GtkMenu *
make_menu()
{
	GtkWidget *menuitem = NULL;
	GtkWidget *ret = NULL;

	ret = gtk_menu_new();
	gtk_widget_show(ret);
	menuitem = gtk_menu_item_new_with_label("Load file");
	gtk_widget_show(menuitem);
	gtk_container_add(GTK_CONTAINER(ret), menuitem);

	g_signal_connect_swapped(G_OBJECT(menuitem), "activate", (GCallback)gtk_rc_parse, "theme-mod.gtkrc");

	return GTK_MENU(ret);
}

static gboolean
wnd_button_press(GtkWidget *wnd, GdkEventButton *event)
{
	gtk_menu_popup(make_menu(), NULL, NULL, NULL, NULL, 1, event->time);

	return TRUE;
}

int
main(int argc, char **argv)
{
	GtkWidget *wnd;

	hildon_gtk_init(&argc, &argv);

	wnd = g_object_new(GTK_TYPE_WINDOW, "visible", TRUE, NULL);
	gtk_widget_add_events(wnd, GDK_BUTTON_PRESS_MASK);

	g_signal_connect(wnd, "delete-event", (GCallback)gtk_main_quit, NULL);
	g_signal_connect(wnd, "button-press-event", (GCallback)wnd_button_press, NULL);

	gtk_main();

	return 0;
}
