/*
 * This file is a part of pidgin-maemo-docklet
 *
 * Copyright (C) 2009-2010 Gabriel Schulhof <nix@go-nix.ca>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _PIDGIN_MAEMO_DOCKLET_GLOBAL_H_
#define _PIDGIN_MAEMO_DOCKLET_GLOBAL_H_

#include <stdarg.h>
#include <glib.h>

G_BEGIN_DECLS

/* #define DEBUG */
#ifdef DEBUG
void debug_print(const char *fmt, ...);
#else /* !DEBUG */
#define debug_print(fmt,...)
#endif /* DEBUG */

#define PIDGIN_SYSTRAY_DBUS_SERVICE_NAME "im.pidgin.pidgin-maemo-docklet"
#define PIDGIN_SYSTRAY_DBUS_SERVICE_PATH "/"
#define PIDGIN_SYSTRAY_DBUS_SERVICE_METHOD_CONNECT "connect"
#define PIDGIN_SYSTRAY_DBUS_SERVICE_METHOD_DISCONNECT "disconnect"
#define PIDGIN_SYSTRAY_DBUS_SERVICE_METHOD_CLICKED "clicked"
#define PIDGIN_SYSTRAY_DBUS_SERVICE_METHOD_SET_TOOLTIP "set_tooltip"
#define PIDGIN_SYSTRAY_DBUS_SERVICE_METHOD_UPDATE_ICON "update_icon"
#define PIDGIN_SYSTRAY_DBUS_SERVICE_METHOD_MUTED_STATUS_CHANGED "muted_status_changed"

G_END_DECLS

#endif /* !_PIDGIN_MAEMO_DOCKLET_GLOBAL_H_ */
