#ifndef VIEWS_PERSON_H
#define VIEWS_PERSON_H

#include "../View.h"

#include "../Data/Person.h"

#include <Lum/Model/Action.h>
#include <Lum/Model/String.h>

#include <Lum/Panel.h>
#include <Lum/String.h>

namespace Views {

  class Person : public ::Base::DataView
  {
  private:
    ::Data::Person        *person;

    Lum::Panel            *panel;

    Lum::Model::StringRef title;
    Lum::Model::StringRef surename;
    Lum::Model::StringRef middlename;
    Lum::Model::StringRef name;
    Lum::Model::StringRef suffix;
    Lum::Model::StringRef nick;

  public:
    Person();

    void RegisterDataViews(Lum::Tab*& tab);

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void Load(::Base::View::DataPtr viewData=NULL);
    void Vanish();
    void Save();
  };

}

#endif
