#include "GUI.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/Size.h>
#include <Lum/Base/String.h>

#include <Lum/Def/Menu.h>

#include <Lum/Dlg/About.h>

#include <Lum/Image.h>
#include <Lum/Panel.h>
#include <Lum/Toolbar.h>

#include "config.h"

static Lum::Def::AppInfo info;
GUI*                     GUI::instance=NULL;

GUI::GUI()
: defaultView(NULL)
{
  info.SetProgram(Lum::Base::StringToWString(PACKAGE_NAME));
  info.SetVersion(Lum::Base::StringToWString(PACKAGE_VERSION));
  info.SetDescription(L"Manage your personal information...");
  info.SetAuthor(L"Tim Teulings");
  info.SetContact(L"Tim Teulings <tim@teulings.org>");
  info.SetCopyright(L"(c) 2005, Tim Teulings");
  info.SetLicense(L"GNU Public License");

  multi=new MultiView();

  firstAction=new Lum::Model::Action();
  previousAction=new Lum::Model::Action();
  aboutAction=new Lum::Model::Action();

  Observe(firstAction);
  Observe(previousAction);
  Observe(aboutAction);
}

GUI* GUI::GetInstance()
{
  if (instance==NULL) {
    instance=new GUI();
  }

  return instance;
}

void GUI::RegisterDefaultView(Base::ViewPtr view)
{
  defaultView=view;
}

void GUI::RegisterView(Base::ViewPtr view)
{
  multi->AddView(view);
}

void GUI::SetView(const StackEntry& entry)
{
  multi->ShowView(entry.view,entry.data);

  if (stack.size()>1) {
    firstAction->Enable();
    previousAction->Enable();
  }
  else {
    firstAction->Disable();
    previousAction->Disable();
  }
}

void GUI::ShowView(const std::wstring& name, Base::View::DataPtr data)
{
  StackEntry entry;

  entry.view=name;
  entry.data=data;
  stack.push(entry);

  SetView(entry);
}

void GUI::PreInit()
{
  std::list<Base::ViewPtr>::const_iterator iter;
  Lum::Button                              *button;
  Lum::Panel                               *vert;
  Lum::Toolbar                             *horiz;

  vert=Lum::VPanel::Create(true,true);
  vert->SetWidth(Lum::Base::Size::workHRel,20);
  vert->SetHeight(Lum::Base::Size::workVRel,10);

  horiz=new Lum::Toolbar();
  horiz->SetFlex(true,false);

/*  image=new Lum::Image();
  image->SetWidth(Lum::Base::Size::modePixel,16);
  image->SetHeight(Lum::Base::Size::modePixel,16);
  image->SetImage(new Lum::Base::VecImage(Lum::Base::VecImage::w95Left));*/

  button=Lum::Button::Create(L"_Home",firstAction,false,true);
  button->SetType(Lum::Button::typeToolBar);
  //button->SetImage(image);
  horiz->Add(button);

  if (Lum::OS::display->GetType()==Lum::OS::Display::typeTextual) {
    button=Lum::Button::Create(L"_Back",previousAction,false,true);
    button->SetType(Lum::Button::typeToolBar);
    horiz->Add(button);
  }
  else {
    Lum::Image *image;

    image=new Lum::Image();
    image->SetWidth(Lum::Base::Size::pixel,16);
    image->SetHeight(Lum::Base::Size::pixel,16);
    image->SetImage(Lum::OS::display->GetImage(Lum::OS::Display::arrowLeftImageIndex));

    button=Lum::Button::Create(image,previousAction,false,true);
    button->SetType(Lum::Button::typeToolBar);
    horiz->Add(button);
  }

  multi->SetFlex(true,true);
  vert->Add(multi);

  SetToolbar(horiz);
  SetMain(vert);

  Lum::Def::Menu *menu=Lum::Def::Menu::Create();

  menu
    ->GroupProject()
      ->ActionQuit(GetClosedAction())
    ->End()
    ->GroupHelp()
      //->ActionHelp()
      ->ActionAbout(aboutAction)
    ->End();

  SetMenu(menu);

  ShowView(defaultView->GetName(),NULL);

  Dialog::PreInit();
}

void GUI::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==firstAction && firstAction->IsFinished()) {
    GotoHome();
  }
  else if (model==previousAction && previousAction->IsFinished()) {
    GotoPrevious();
  }
  else if (model==aboutAction && aboutAction->IsFinished()) {
    Lum::Dlg::About::Show(this,info);
  }
  else {
    Dialog::Resync(model,msg);
  }
}

void GUI::GotoHome()
{
  StackEntry entry;

  while (stack.size()>1) {
    delete stack.top().data;
    stack.pop();
  }

  entry=stack.top();

  SetView(entry);
}

void GUI::GotoPrevious()
{
  if (stack.size()==1) {
    return;
  }

  StackEntry entry;

  delete stack.top().data;
  stack.pop();

  entry=stack.top();

  SetView(entry);
}
