#ifndef DATA_NOTE_H
#define DATA_NOTE_H

#include "../Data.h"

namespace Data {
  class Note : public ::Base::Data
  {
  public:
    class NoteType : public ::Base::Type
    {
    public:
      enum Attribute
      {
        text = 0
      };

    public:
      NoteType();

      unsigned long GetMaxAttribute() const;
      bool IsPrimaryType() const;

      ::Base::DataPtr Create() const;
    };

  public:
    static NoteType *noteType;

  public:
    std::wstring text;

  public:
    Note();

    std::wstring GetDisplayText() const;

    void SetAttribute(::Base::Id id, const std::wstring& value);
    std::wstring GetAttribute(::Base::Id id) const;
    bool IsMultilineAttribute(Base::Id id) const;
  };

  typedef Note *NotePtr;
}

#endif
