#ifndef DATA_MSISDN_H
#define DATA_MSISDN_H

#include "../Data.h"

namespace Data {
  class MSISDN : public ::Base::Data
  {
  public:
    class MSISDNType : public ::Base::Type
    {
    public:
      enum Attribute
      {
        msisdn  = 0
      };

    public:
      MSISDNType();

      unsigned long GetMaxAttribute() const;
      bool IsPrimaryType() const;

      ::Base::DataPtr Create() const;
    };

  public:
    static MSISDNType *msisdnType;

  public:
    std::wstring msisdn;

  public:
    MSISDN();

    bool IsGreater(Data* other) const;

    std::wstring GetDisplayText() const;

    void SetAttribute(::Base::Id id, const std::wstring& value);
    std::wstring GetAttribute(::Base::Id id) const;
  };

  typedef MSISDN *MSISDNPtr;
}

#endif
