#include "Location.h"

#include <assert.h>

namespace Data {
  Location::LocationType *Location::locationType=new Location::LocationType();

  Location::LocationType::LocationType()
  : Type(L"Location")
  {
    RegisterAttribute(L"street",street);
    RegisterAttribute(L"city",city);
    RegisterAttribute(L"zip",zip);
    RegisterAttribute(L"state",state);
    RegisterAttribute(L"country",country);
  }

  unsigned long Location::LocationType::GetMaxAttribute() const
  {
    return country;
  }

  bool Location::LocationType::IsPrimaryType() const
  {
    return false;
  }

  ::Base::DataPtr Location::LocationType::Create() const
  {
    return new Location;
  }

  Location::Location()
   : Data(locationType)
  {
    // no code
  }

  std::wstring Location::GetDisplayText() const
  {
    std::wstring res;

    res.append(street);

    if (!city.empty()) {
      if (!res.empty()) {
        res.append(L", ");
      }
      res.append(city);
    }

    if (!zip.empty()) {
      if (!res.empty()) {
        res.append(L", ");
      }
      res.append(zip);
    }

    if (!state.empty()) {
      if (!res.empty()) {
        res.append(L", ");
      }
      res.append(state);
    }

    if (!country.empty()) {
      if (!res.empty()) {
        res.append(L", ");
      }
      res.append(country);
    }

    return res;
  }

  void Location::SetAttribute(::Base::Id id, const std::wstring& value)
  {
    switch (id) {
    case LocationType::street:
      street=value;
      break;
    case LocationType::city:
      city=value;
      break;
    case LocationType::zip:
      zip=value;
      break;
    case LocationType::state:
      state=value;
      break;
    case LocationType::country:
      country=value;
      break;
    default:
      assert(false);
    }
  }

  std::wstring Location::GetAttribute(Base::Id id) const
  {
    switch (id) {
    case LocationType::street:
      return street;
    case LocationType::city:
      return city;
    case LocationType::zip:
      return zip;
    case LocationType::state:
      return state;
    case LocationType::country:
      return country;
    default:
      assert(false);
    }
  }
}
