#include "EMail.h"

#include <assert.h>

namespace Data {
  EMail::EMailType *EMail::emailType=new EMail::EMailType();

  EMail::EMailType::EMailType()
  : Type(L"EMail")
  {
    RegisterAttribute(L"email",email);
  }

  unsigned long EMail::EMailType::GetMaxAttribute() const
  {
    return email;
  }

  bool EMail::EMailType::IsPrimaryType() const
  {
    return false;
  }

  ::Base::DataPtr EMail::EMailType::Create() const
  {
    return new EMail;
  }

  EMail::EMail()
   : Data(emailType)
  {
    // no code
  }

  std::wstring EMail::GetDisplayText() const
  {
    return email;
  }

  void EMail::SetAttribute(::Base::Id id, const std::wstring& value)
  {
    switch (id) {
    case EMailType::email:
      email=value;
      break;
    default:
      assert(false);
    }
  }

  std::wstring EMail::GetAttribute(Base::Id id) const
  {
    switch (id) {
    case EMailType::email:
      return email;
    default:
      assert(false);
    }
  }
}
