#ifndef BASE_VIEW_H
#define BASE_VIEW_H

#include "Data.h"

#include <list>

#include <Lum/Base/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/Table.h>

#include <Lum/Object.h>
#include <Lum/Tab.h>
#include <Lum/Table.h>

namespace Base {
  class View : public Lum::Group
  {
  public:
    class Data
    {
    public:
      ::Base::DataPtr data;
      ::Base::DataPtr linkData;
      std::wstring    linkName;


    public:
      Data(::Base::DataPtr data);
      Data(::Base::DataPtr data,
           ::Base::DataPtr linkData,
           const std::wstring linkName);
      virtual ~Data();

      bool RequestsLink() const;
      void ClearLinkInfo();
    };

    typedef Data *DataPtr;

  private:
    std::wstring name;

  public:
    View(const std::wstring& name);

    std::wstring GetName() const;

    virtual void Load(DataPtr viewData) = 0;
    virtual void Vanish() = 0;
  };

  typedef View *ViewPtr;

  class DataView : public View
  {
  private:
    std::list<Lum::Base::Model*>   models; //< List of models that display the data
    Lum::Table                     *linkTable;
    Lum::Model::ListTableRef       linkModel;
    Lum::Model::ActionRef          showLinkAction;
    Lum::Model::ActionRef          addLinkAction;
    Lum::Model::ActionRef          referenceAction;
    Lum::Model::ActionRef          renameLinkAction;
    Lum::Model::ActionRef          deleteLinkAction;
    Lum::Panel                     *panel;

  protected:
    Lum::Model::ActionRef          saveAction;
    DataPtr                        viewData;
    ::Base::Data                   *data;   //< The data object itself

  protected:
    void RefreshLinkTable();

    void SetViewData(DataPtr viewData);

    virtual void RegisterDataViews(Lum::Tab*& tab);

  public:
    DataView(const std::wstring& name);
    ~DataView();

    void Load(DataPtr viewData);
    void Vanish();

    virtual void Save() = 0;

    bool VisitChildren(Lum::Visitor &visitor, bool onlyVisible);
    void CalcSize();
    void Layout();

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void RegisterModel(Lum::Base::Model* model);
    bool IsRegisteredModel(Lum::Base::Model* model) const;
  };
}

#endif
