#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QFile>
#include <QCoreApplication>
#include <QTextStream>
#include <QProcess>
#include <QtGui/QCloseEvent>
#include <QSettings>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    videoyes = true; //so that sdpgen denerates the right file, when presed by itself.
    sdpyes = false;
    //cambackyes=false;
    ui->setupUi(this);
    debugclicked = false;
    ui->labcust->hide();
    ui->custom1->hide();
    ui->outWind->hide();
    ui->sdpgen->hide();
    ui->stopsream->hide();
    ui->howtext->hide();
    ui->filesinkname->hide();
    ui->labfilenam->hide();
    ui->lenswidg->setStyleSheet("QWidget { background-color: rgb(60, 60, 100); }");
    ui->labcamwarn->setStyleSheet("QLabel {color : black;}");
    ui->okstream->setStyleSheet("QPushButton {background-color : black; color : white;}");
    ui->how->setStyleSheet("QPushButton {background-color : black; color : white;}");
    ui->howtext->setStyleSheet("QTextBrowser {background-color : rgb(223, 223, 223); color : black;}");
    ui->scpframe->setStyleSheet("QWidget { background-color: black;}");
    ui->labscpuser->setStyleSheet("QLabel {color : white;}");
    ui->labscppass->setStyleSheet("QLabel {color : white;}");
    ui->scpsend->setStyleSheet("QPushButton {background-color : white; color : black;}");
    ui->usernam->setStyleSheet("QLineEdit {background-color : white; color : black;}");
    ui->passwrd->setStyleSheet("QLineEdit {background-color : white; color : black;}");
    ui->lenswidg->hide();
    ui->scpbutton->hide();
    ui->scpframe->hide();
    ui->passwrd->setEchoMode(QLineEdit::Password);
    helpCounter=0;
    ui->qcontrol->hide();
    applySettings();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::makeStream(QString host, bool backcamera, bool video, QString port, QString width, QString height, int outp){
    QString midbits;
    QString streamout;
    QString qbcam;
    QString Jquality;
    if(ui->tickqual->isChecked()){Jquality= "quality="+ui->qcontrol->text();}else{Jquality="";}   //necessary because the option kills quality, even if 100%
    if(video){
        if(backcamera){ qbcam = "0"; } else { qbcam = "1";}
        if(outp!=3){ //filesink? no
            if(outp==0){//VLC
                midbits = "dsph264enc ! rtph264pay ! udpsink";
            } else if (outp==1){ //Xout
                midbits = "ffmpegcolorspace ! jpegenc "+Jquality+" ! tcpserversink";
            } else if (outp==2){//webcam
                //midbits = "ffmpegcolorspace ! smokeenc ! udpsink";  using jpeg for quality preferences.
                midbits = "ffmpegcolorspace ! jpegenc "+Jquality+" ! tcpserversink";
            } else if (outp==4){ //remote file
                midbits = "ffmpegcolorspace ! jpegenc "+Jquality+" ! tcpserversink";
            }
            streamout = "gst-launch-0.10 v4l2src device=/dev/video"+qbcam+" ! videoscale ! video/x-raw-yuv,width="+width+",height="+height+" !"+midbits+" host="+host+" port="+port;
        }
        else if(outp==3){ //filesink
            QString filelocation = ui->filesinkname->text();
            streamout = "gst-launch-0.10 v4l2src device=/dev/video"+qbcam+" ! videoscale ! video/x-raw-yuv,width="+width+",height="+height+" ! ffmpegcolorspace ! jpegenc "+Jquality+" ! avimux ! filesink location=/home/user/MyDocs/.videos/"+filelocation+".avi";
        }
    }
    else if (!video){
        streamout = "gst-launch-0.10 pulsesrc ! audioconvert ! volume volume="+ui->vol->text()+" ! audioresample ! nokiaaacenc ! rtpmp4apay ! udpsink host="+host+" port="+port;
    }
    ui->outWind->setText("currently streaming.");
    QProcess*proc = new QProcess();
    proc->start(streamout);
    ui->outWind->append(proc->readAll()); //NOW JUST NEED TO PASS OUTPUT FROM GST-LAUNCH BACK INTO OUTWIND
 }

void MainWindow::write2file(QString path, QString script){
    //writing bash script
    QFile file(path);
    file.open(QIODevice::WriteOnly | QIODevice::Text);
    QTextStream out(&file);
    out << script;
    file.close();
    ui->outWind->append("Generated");

    //make executable-----------------doesnt work
    QStringList arguments;
    arguments << "-c" << "chmod a+x "+path;
    QProcess* exer = new QProcess(this);
    exer->start("/bin/sh", arguments);
    exer->waitForFinished();
    exer->terminate();
 }

void MainWindow::on_streambut_clicked()
{
    ui->address1->setProperty("enabled", false);ui->port1->setProperty("enabled", false); ui->type1->setProperty("enabled", false); ui->size1->setProperty("enabled", false);
    ui->camera1->setProperty("enabled", false);ui->custom1->setProperty("enabled",false);ui->outWind->setProperty("enabled", false); ui->debuginfo->setProperty("enabled",false);
    ui->sdpgen->setProperty("enabled", false); ui->scpbutton->setProperty("enabled", false);ui->vol->setProperty("enabled",false);ui->vidsink->setProperty("enabled",false);
    ui->stopsream->show(); ui->streambut->hide();
    ui->tickqual->setProperty("enabled",false);ui->qcontrol->setProperty("enabled",false); ui->filesinkname->setProperty("enabled",false);
    //cameraselector
    if(ui->type1->currentIndex()==0 && ui->camera1->currentIndex()==0){
        cambackyes=true;
        helpCounter ++;
        ui->lenswidg->show();
        if(helpCounter > 1){ streamProcess1();}
    }
    else {
        cambackyes=false;
        streamProcess1();
    }

}

void MainWindow::writeSettings(){
    QSettings settings("daUser", "tester");
    settings.beginGroup("MainWindow"); //beginWriteArray?
    settings.setValue("address",ui->address1->text());settings.setValue("port",ui->port1->text());
    settings.setValue("type",ui->type1->currentIndex()); settings.setValue("camera",ui->camera1->currentIndex()); settings.setValue("size",ui->size1->currentIndex());
    settings.setValue("custom",ui->custom1->text()); settings.setValue("user",ui->usernam->text()); settings.setValue("password",ui->passwrd->text());settings.setValue("volume", ui->vol->text());
    settings.setValue("quality",ui->qcontrol->text());
    settings.endGroup();
}

void MainWindow::applySettings(){
    QSettings settings("daUser", "tester");
    settings.beginGroup("MainWindow");
    ui->address1->setText(settings.value("address").toString()); ui->port1->setText(settings.value("port").toString()); ui->type1->setCurrentIndex(settings.value("type").toInt());
    ui->size1->setCurrentIndex(settings.value("size").toInt()); ui->camera1->setCurrentIndex(settings.value("camera").toInt());
    ui->custom1->setText(settings.value("custom").toString());ui->usernam->setText(settings.value("user").toString()); ui->passwrd->setText(settings.value("password").toString());
    volumeR = settings.value("volume").toString(); ui->vol->setText(volumeR); ui->qcontrol->setText(settings.value("quality").toString());
    settings.endGroup();
    if(ui->type1->currentIndex()==1){
        on_type1_activated(1);
    }
    else {
        on_type1_activated(0);
    }
}

void MainWindow::streamProcess1(){
    hostname = ui->address1->text();
    portnum = ui->port1->text();
    //getting the size
    QString currentsize = ui->size1->currentText();
    if(currentsize == "Custom"){
        currentsize = ui->custom1->text();
    }
    //splitting the string
    QStringList sized = currentsize.split("x");
    widthnum = sized[0];
    heightnum = sized[1];
    int currOutput = ui->vidsink->currentIndex();
    makeStream(hostname,cambackyes,videoyes,portnum,widthnum,heightnum, currOutput);
}

void MainWindow::scpSender(QString user, QString pass, QString file){
    QString expectfile = QString("#!/usr/bin/expect -f\nset filename [lindex $argv 0]\nset user [lindex $argv 1]\nset pass [lindex $argv 2]\nset ipadd [lindex $argv 3]\nset timeout -1\nspawn scp $filename $user@$ipadd:/home/$user/Desktop\nexpect {\n%1yes/no)?%1 {exp_send %1yes%2r%1; exp_continue}\n%1*assword:%1 { send %1$pass%2r%1; exp_continue}\neof exit\n}").arg(QChar(0x22),QChar(0x5c));
    write2file("/home/user/.scp",expectfile);
    QProcess*sender1 = new QProcess();
    sender1->start("expect /home/user/.scp "+file+" "+user+" "+pass+" "+ui->address1->text());
    sender1->waitForFinished();
    ui->outWind->append("Done....check your desktop's desktop");
    sender1->terminate();
}

void MainWindow::on_type1_activated(int index) //link on cmera1_activated into this? and then link size_activate into camera1_actiavet?!?!
{
    if(index==1){ //Audio
        ui->labCam->hide();
        ui->labsize->hide();
        ui->camera1->hide();
        ui->size1->hide();
        ui->custom1->hide();
        ui->labcust->hide();
        ui->vidsink->hide();
        ui->labvidsink->hide();ui->labvol->setText("Vol(0-9):");
        ui->vol->setText(volumeR);
        ui->vol->show();
        ui->labvol->show();
        ui->tickqual->hide();
        ui->qcontrol->hide();
        ui->labfilenam->hide();
        ui->filesinkname->hide();
        videoyes = false;
    }
    else { //Video
        ui->labCam->show();
        ui->labsize->show();
        ui->camera1->show();
        ui->size1->show();
        ui->vidsink->show();
        ui->labvidsink->show();
        ui->vol->hide();
        ui->labvol->hide();
        on_tickqual_toggled(ui->tickqual->checkState());
        on_vidsink_activated(ui->vidsink->currentIndex());
        on_camera1_activated(ui->camera1->currentIndex()); ///CORRECT?
        on_size1_currentIndexChanged(ui->size1->currentText());
        videoyes = true;
    }
}

void MainWindow::on_camera1_activated(int index)
{
    if(index==1){
        cambackyes = false;
        if(ui->size1->itemText(0)=="640x480"){
            ui->size1->removeItem(0);
        }
    }
    else {
        cambackyes = true;
        if(ui->size1->itemText(0)!="640x480"){
            ui->size1->insertItem(0,"640x480");
        }
    }
}

void MainWindow::on_size1_currentIndexChanged(QString isCustom)
{
    if(isCustom=="Custom"){
        ui->labcust->show();
        ui->custom1->show();
    }
    else{
        ui->labcust->hide();
        ui->custom1->hide();
        ui->custom1->clear();
    }
}

void MainWindow::on_debuginfo_clicked()
{
    ui->outWind->show();
    ui->sdpgen->show();
    debugclicked = true;
}

QString MainWindow::getIP(){
    QStringList arguments1;
    arguments1 << "-c" << "sudo ifconfig  | grep 'inet addr:'| grep -v '127.0.0.1' | cut -d: -f2 | awk '{ print $1}'";
    QProcess*process1 = new QProcess(this);
    process1->start("/bin/sh", arguments1);
    process1->waitForFinished();
    QString tmp = process1->readAll();
    tmp = tmp.split(QRegExp("\\s+")).at(0); //removes spaces at end
    return tmp;

}

void MainWindow::on_sdpgen_clicked()
{
    sdpyes = false;
    QString localip=getIP();
    ui->outWind->setText("local ip is "+localip);
    QString decoder;QString typer;
    int outpp = ui->vidsink->currentIndex();

    if(outpp==0){ //VLC
        if(videoyes){ typer = "video"; decoder ="H264/90000";}
        else if(!videoyes){ typer="audio"; decoder="MP4A-LATM/48000/2";}
        currentFile ="/home/user/MyDocs/n900"+typer+"strm.sdp";
        write2file(currentFile,"v=0\nm="+typer+" "+ui->port1->text()+" RTP/AVP 96\nc=IN IP4 "+localip+"\na=rtpmap:96 "+decoder); //VLC
    }
    else if(outpp==1) { //Xout
        currentFile = "/home/user/MyDocs/n900Xvideo.sh";
        write2file(currentFile,"gst-launch-0.10 tcpclientsrc host="+localip+" port="+ui->port1->text()+"  ! jpegdec ! autovideosink"); //Xout
    }
    else if(outpp==2) { //webcam
        currentFile = "/home/user/MyDocs/n900Webvideo.sh";
        //write2file(currentFile,"gst-launch-0.10 udpsrc port="+ui->port1->text()+" ! smokedec ! ffmpegcolorspace ! v4l2loopback device=/dev/video0");  //webcam
        //Using Jpeg for now, higer quality?
        write2file(currentFile,"gst-launch-0.10 tcpclientsrc host="+localip+" port="+ui->port1->text()+"  ! jpegdec ! ffmpegcolorspace ! v4l2loopback device=/dev/video0"); //Xout
    }
    else if(outpp==3) {//filesink
        ui->outWind->setText("Dont need to generate anything for a filesink.");
    }
    else if(outpp==4){//remote filesink
        currentFile = "/home/user/MyDocs/n900FileSave.sh";
        write2file(currentFile,"gst-launch-0.10 tcpclientsrc host="+localip+" port="+ui->port1->text()+" ! jpegdec ! ffenc_mpeg2video ! filesink location=/home/"+ui->usernam->text()+"/Desktop/"+ui->filesinkname->text()+".mpg");
    }
    sdpyes=true;
    ui->scpbutton->show();
}

void MainWindow::on_stopsream_clicked()
{
    QProcess*terminator = new QProcess();
    QProcess*ledterm = new QProcess();
    terminator->start("killall gst-launch-0.10");
    terminator->waitForFinished();
    terminator->terminate();
    //Turn off LED
    QString lstream = QString("dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_led_pattern_deactivate string:%1PatternWebcamActive%1").arg(QChar(0x22));
    ledterm->start(lstream);
    ledterm->waitForFinished();
    //
    ui->outWind->clear();
    ui->outWind->append("Stopped Steaming");
    ui->stopsream->hide();
    ui->streambut->show();
    //making everything visible
    ui->address1->setProperty("enabled", true);ui->port1->setProperty("enabled", true); ui->type1->setProperty("enabled", true); ui->size1->setProperty("enabled", true);
    ui->custom1->setProperty("enabled",true);ui->outWind->setProperty("enabled", true); ui->debuginfo->setProperty("enabled",true);ui->camera1->setProperty("enabled", true);
    ui->sdpgen->setProperty("enabled", true); ui->scpbutton->setProperty("enabled", true);ui->vol->setProperty("enabled",true);ui->vidsink->setProperty("enabled",true);
    ui->tickqual->setProperty("enabled",true);ui->qcontrol->setProperty("enabled",true);ui->filesinkname->setProperty("enabled",true);
    //
    ledterm->terminate();
    proc.terminate();//doesn't do anything really
}

void MainWindow::closeEvent(QCloseEvent *event)
{
   event->ignore();
   on_stopsream_clicked();  //closes all stream
   writeSettings();
   event->accept();
}

void MainWindow::on_how_clicked()
{
    ui->howtext->show();
}

void MainWindow::on_okstream_clicked()
{
    ui->lenswidg->resize(QSize::QSize(0,0));
    on_streambut_clicked();
}

void MainWindow::on_scpbutton_clicked()
{
  ui->outWind->setText("This will only work if your username is the same on the PC: e.g <user>@192.168.2.12:/home/<user>/Desktop");
  ui->scpframe->show();
}

void MainWindow::on_scpsend_clicked()
{
    ui->scpsend->setStyleSheet("QPushButton {background-color : rgb(60, 60, 100); color : white;}");
    ui->scpframe->hide();
    ui->outWind->setText("Sending....\nPlease Wait");
    scpSender(ui->usernam->text(),ui->passwrd->text(),currentFile);
    ui->scpsend->setStyleSheet("QPushButton {background-color : white; color : black;}");
}

void MainWindow::on_vidsink_activated(int index)
{
    if(index==3 || index==4){//File
        ui->labfilenam->show();
        ui->filesinkname->show();
        ui->tickqual->show();
        if(index==3){
            ui->sdpgen->hide();
            ui->scpbutton->hide();
            ui->labfilenam->setText("     Filename (/home/user/MyDocs/.videos/):");
            //Hide top row
            ui->address1->hide(); ui->labAddr->hide(); ui->port1->hide(); ui->labPort->hide();
        }
        if(index==4) {
            ui->sdpgen->show();
            ui->labfilenam->setText("    Remote Filename:");
            vidoutput="RemoteFilescript";
            ui->address1->show(); ui->labAddr->show(); ui->port1->show(); ui->labPort->show();
        }

    } else if(index!=3 || index!=4){
        ui->address1->show(); ui->labAddr->show(); ui->port1->show(); ui->labPort->show();
        ui->labfilenam->hide();
        ui->filesinkname->hide();
        if(debugclicked){ui->sdpgen->show();}// stops it appearing when showdebug hasnt been clicked yet
        if(index==0){
            vidoutput = "VLC sdp";
            ui->tickqual->hide();
            ui->qcontrol->hide();
        } else {
            ui->tickqual->show();
            if(index==1){vidoutput = "Xscript";}
            if(index==2){vidoutput="Webscript";}
        }
    }
    ui->sdpgen->setText("Generate "+vidoutput+" file");
    ui->scpbutton->setText("Send "+vidoutput+" to Linux PC");
}
/*
Add microphone support for use as main remote desktop mic.??
Fix script for front camera + LED shutdown on some devices. ??
Fix IP address issues
Add zooming feature
Ncurses version
Stream to a file
Stream to the web as watchdog
*/

void MainWindow::on_tickqual_toggled(bool checked)
{
    if(checked==true){
        ui->labvol->hide();
        ui->qcontrol->show();
    }
    else if(checked==false) {
        ui->qcontrol->hide();
    }
}
