#include <QtGui/QApplication>
#include "qmlapplicationviewer.h"
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include "Bunker.h"
#include "HiScores.h"
#include "HiScoreModel.h"
#include "Helper.h"

#define VER1_(x) #x
#define VER_(x)	VER1_(x)
#define VER VER_(MYVERSION)

int main(int argc, char *argv[])
{
    //qputenv("N900_PORTRAIT_SENSORS", "1");

    qDebug() << VER;
    QApplication app(argc, argv);

    qmlRegisterType<Bunker>("SpaceInvaders", 1, 0, "Bunker");
    QCoreApplication::setOrganizationName("PGZ");
    QCoreApplication::setOrganizationDomain("piggz.co.uk");
    QCoreApplication::setApplicationName("pgz-spaceinvaders");

    QmlApplicationViewer viewer;
    HiScores hiscores;
    HiScoreModel globalhiscores;
    Helper helper;

    viewer.rootContext()->setContextProperty("HiScores", &hiscores);
    viewer.rootContext()->setContextProperty("GlobalHiScores", &globalhiscores);
    viewer.rootContext()->setContextProperty("Helper", &helper);
    viewer.rootContext()->setContextProperty("Viewer", &viewer);

    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationLockLandscape);

    viewer.engine()->addImportPath(QString("/opt/qtm12/imports"));

    viewer.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    viewer.setGeometry(100, 100, 640, 320);
    viewer.setMainQmlFile(QLatin1String("qml/pgz-spaceinvaders/main.qml"));
    viewer.showExpanded();

    return app.exec();
}
