#ifndef HISCORES_H
#define HISCORES_H

#include <QObject>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>

//An interface to the web based hi scores

class HiScores : public QObject
{
    Q_OBJECT
public:
    explicit HiScores(QObject *parent = 0);
    ~HiScores();

signals:
    void messageReceived();

public slots:
    void createAccount(const QString &gamerName, const QString &password);
    void sendHiScore(const QString &gamerName, const QString &password, const QString &level, const QString &score, const QString &scoredate);
    QString lastMessage();

private slots:
    void replyFinished(QNetworkReply*);

private:
    QNetworkAccessManager *m_networkManager;
    QString m_lastMessage;
};

#endif // HISCORES_H
