import QtQuick 1.0

Item {
    id: exitDialog
    width: 250
    height: 150
    state: "HIDDEN"

    signal clickedYes
    signal clickedNo

  Rectangle {
    anchors.fill: parent
    color: "#000000"
    border.width: 3
    border.color: "#00ff00"



    Text {
        id: text1
        x: 18
        y: 25
        color: "#00ff00"
        text: "Are you sure you want to exit?"
        font.pixelSize: 14
    }

    Rectangle {
        id: rectangle1

        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.bottomMargin: 20
        anchors.leftMargin: 20

        width: 64
        height: 64
        color: "#000000"
        border.width: 3
        border.color: "#00ff00"

        MouseArea {
            id:areaNo
            anchors.fill: parent

        }

        Text {
            id: txtNo
            text: "No"
            anchors.centerIn: parent
            color: "#00ff00"
        }
    }

    Rectangle {
        id: rectangle2

        anchors.bottom: parent.bottom
        anchors.right: parent.right
        anchors.bottomMargin: 20
        anchors.rightMargin: 20

        width: 64
        height: 64
        color: "#000000"
        border.color: "#00ff00"
        border.width: 3

        MouseArea {
            id:areaYes
            anchors.fill: parent
        }

        Text {
            id: txtYes
            text: "Yes"
            anchors.centerIn: parent
            color: "#00ff00"
        }
    }
  }

  states: [
      State {
          name: "HIDDEN"
          PropertyChanges { target: exitDialog; scale: 0}
      },
      State {
          name: "VISIBLE"
          PropertyChanges { target: exitDialog; scale: 1}
      }
  ]

  transitions: Transition {
      NumberAnimation { properties: "scale"; easing.type: Easing.OutBounce; duration: 1000 }
  }

  Component.onCompleted: {
      areaYes.clicked.connect(clickedYes);
      areaNo.clicked.connect(clickedNo);
  }

}
