import QtQuick 1.0
import QtMobility.sensors 1.1
import Qt 4.7
import QtMultimediaKit 1.1
import SpaceInvaders 1.0

import "logic.js" as Logic
//import "bunker.js" as Bunker1;
//import "bunker.js" as Bunker2;
//import "bunker.js" as Bunker3;
//import "bunker.js" as Bunker4;
import "storage.js" as Settings;

Rectangle {
    id: board
    width: 800
    height: 480
    color: "#000000"

    ColorAnimation on color {id:flashanim; from: "#999999"; to: "black"; duration: 200 }

    MouseArea {
           id: themousearea
           x: 0
           y: 30
           width: 800
           height: 449
           drag.minimumY: -1000
           drag.minimumX: -1000
           drag.maximumY: 1000
           drag.maximumX: 1000
           anchors.rightMargin: 0
           anchors.bottomMargin: 1
           anchors.leftMargin: 0
           anchors.topMargin: 30
           anchors.fill: board
           onPressed: {
                Logic.screenTap();
           }
       }

    Text {
        id: scoretext
        text: "Score: 0"
        color: "#ffffff"
        x: 5
        y: 5
    }

    Text {
        id: leveltext
        text: "Level: 0"
        color: "#ffffff"
        y: 5
        anchors.horizontalCenter: board.horizontalCenter
    }

    Text {
        id: starttext
        text: "Tap screen to start"
        color: "#ffffff"
        anchors.horizontalCenter: board.horizontalCenter
        anchors.verticalCenter: board.verticalCenter
    }

    Rectangle {
        id: messagecontainer
        color: "black"
        height: messagetext.height + 20
        width:  messagetext.width + 20
        visible: false
        anchors.horizontalCenter: board.horizontalCenter
        anchors.verticalCenter: board.verticalCenter

        z:10

        Text {
            id: messagetext
            text: ""
            font.pixelSize: 40
            font.bold: true
            color: "#00ff00"
            anchors.horizontalCenter: messagecontainer.horizontalCenter
            anchors.verticalCenter: messagecontainer.verticalCenter
            visible: true

            Timer {
                id: messagetimer
                interval:  1000
                running: false
                repeat: false
                onRunningChanged: {
                    if (messagetimer.running) {
                        messagecontainer.visible = true;
                    }
                }

                onTriggered: {
                    messagecontainer.visible = false;
                }
            }
        }
    }


    Ship {
        id:ship
        x: 355
        y: 410
    }

    Timer {
             id: heartbeat;
             interval: 50
             running: false;
             repeat: true;
             onTriggered: Logic.mainEvent();
         }

    Timer {
        id: alienanimation
        interval:  600
        running: false
        repeat: true
        onTriggered: Logic.moveAliens()
    }

    Timer  {
        id: deadtimer
        interval: 5000
        running: false
        repeat: false
        onTriggered: {
            Logic.cmdNotRunning();
        }
    }

    Image {
        id: closebutton

        source: "pics/close.png"
        width: 35
        height: 35
        anchors.right: parent.right
        anchors.rightMargin: 0
        anchors.top: parent.top
        anchors.topMargin: 0
        fillMode: Image.PreserveAspectFit
        smooth: false

        MouseArea {
               id: closearea
               anchors.fill: closebutton
               onPressed: Qt.quit()
               }
           }


    Image {
        id: settingsbutton
        source: "pics/settings.png"
        anchors.right: settingspanel.left
        anchors.bottom: board.verticalCenter
        anchors.bottomMargin: 10
        width: 60
        height: 60


        MouseArea {
            id: settingsarea
            anchors.fill: settingsbutton
            onClicked: {
                if (settingspanel.state == "HIDDEN") {
                    settingspanel.state = "VISIBLE";

                } else {
                    settingspanel.state = "HIDDEN";
                }
            }
        }
    }


    Image {
        id: hiscorebutton
        source: "pics/hiscore.png"
        anchors.right: hiscorepanel.left
        anchors.top: board.verticalCenter
        anchors.topMargin: 10
        width: 60
        height: 60


        MouseArea {
            id: hiscorearea
            anchors.fill: hiscorebutton
            onClicked: {
                if (hiscorepanel.state == "HIDDEN") {
                    hiscorepanel.state = "VISIBLE";

                } else {
                    hiscorepanel.state = "HIDDEN";
                }
            }
        }
    }


    Rectangle {
        width: 800
        height:  1
        x: 0
        y: 450
        color: "#00ff00"

    }

    Rectangle {
        width: 800
        height:  1
        x: 0
        anchors.top: closebutton.bottom
        color: "#00ff00"
    }

    Accelerometer  {
        id: accelerometer
        Component.onCompleted: start()
        onReadingChanged: {
            var r = reading
            Logic.scheduleDirection((r.x) * -5);

        }
    }

    Settingswindow {
        id:settingspanel;
        z: 10
    }

    Hiscorewindow {
        id:hiscorepanel;
        z: 9
    }

    SoundEffect {
        id: shootSound
        source: "sounds/shoot.wav"
    }

    SoundEffect {
        id: destroyAlienSound
        source: "sounds/invaderkilled.wav"
    }

    SoundEffect {
        id: destroyShipSound
        source: "sounds/explosion.wav"
    }

    Bunker {
        id: bunker1
        x: 96
        y: 340
        width: 5*15
        height: 4*15
    }
    Bunker {
        id: bunker2
        x: (96*2) + 80
        y: 340
        width: 5*15
        height: 4*15
    }
    Bunker {
        id: bunker3
        x: (96*3) + 160
        y: 340
        width: 5*15
        height: 4*15
    }
    Bunker {
        id: bunker4
        x: (96*4) + 220
        y: 340
        width: 5*15
        height: 4*15
    }

    function startupFunction() {
        Settings.initialize();
        Settings.loadSettings();
        Logic.cmdNotRunning();
    }

    focus: true

    Component.onCompleted: startupFunction();

    Keys.onSpacePressed: Logic.screenTap();
    Keys.onLeftPressed: Logic.scheduleDirection(-10);
    Keys.onRightPressed: Logic.scheduleDirection(10);
    Keys.onEscapePressed: Qt.quit();

    Keys.onPressed: {
        if (event.key == Qt.Key_P) {
            if (Logic.state == "RUNNING") {
                Logic.cmdPause();
            } else if (Logic.state == "PAUSED") {
                Logic.cmdResume();
            }
        } else if (event.key == Qt.Key_Q) {
            if (Logic.state != "NOTRUNNING") {
                Logic.cmdDead();
            }
        }
    }

    Keys.onReleased: {
        if (event.key == Qt.Key_Left || event.key == Qt.Key_Right) {
            Logic.direction = 0
        }
    }

    function displayMessage(msg) {
        messagetext.text = msg;
        messagecontainer.width = messagetext.width + 20
        messagecontainer.visible = true;
    }

    function hideMessage() {
        messagecontainer.visible = false;
    }

}


