import QtQuick 1.0

Item {
    id: levelScoreBoard
    width: 400
    height: 300

    property int currentLevel: 0
    property int numBales: 0
    property int numPlanks: 0
    property int numBricks: 0
    property int timeTaken: 0

    property int totalBales: 0
    property int totalPlanks: 0
    property int totalBricks: 0
    property int timeBonus: 0

    state: "HIDDEN"

    Image {
        anchors.fill: parent
        source: "pics/levelscoreboard.svg"

        Text {
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.top: parent.top
            anchors.topMargin: 10

            color: "white"
            text: "Level " + currentLevel + " complete"

            font.pixelSize: 30
            font.bold: true
            style: Text.Outline
            styleColor: "black"
        }

        Image {
            id: imageType1
            anchors.left: parent.left
            anchors.leftMargin: 30
            anchors.top: parent.top
            anchors.topMargin: 50

            width: 96
            height: 48

            source: "levels/" + mainBoard.selectedLevelPack + "/bale-1.svg"
        }

        Image {
            id: imageType2
            anchors.left: parent.left
            anchors.leftMargin: 30
            anchors.top: imageType1.bottom
            anchors.topMargin: 10

            width: 96
            height: 48

            source: "levels/" + mainBoard.selectedLevelPack + "/wood-2.svg"
        }

        Image {
            id: imageType3
            anchors.left: parent.left
            anchors.leftMargin: 30
            anchors.top: imageType2.bottom
            anchors.topMargin: 10

            width: 96
            height: 48

            source: "levels/" + mainBoard.selectedLevelPack + "/brick-3.svg"
        }

        Image {
            id: imageTime
            anchors.horizontalCenter: imageType3.horizontalCenter
            anchors.top: imageType3.bottom
            anchors.topMargin: 10

            width: 48
            height: 58

            source: "pics/stopwatch.svg"
        }

        Text {
            id: txtType1Num
            anchors.left: imageType1.right
            anchors.verticalCenter: imageType1.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true

            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: "x  " + numBales
        }

        Text {
            id: txtType2Num
            anchors.left: imageType2.right
            anchors.verticalCenter: imageType2.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true

            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: "x  " + numPlanks
        }

        Text {
            id: txtType3Num
            anchors.left: imageType3.right
            anchors.verticalCenter: imageType3.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true
            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: "x  " + numBricks
        }

        Text {
            id: txtTimeTaken
            anchors.left: txtType3Num.left
            anchors.verticalCenter: imageTime.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true
            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: timeTaken + " s"
        }

        Text {
            id: txtType1Total
            anchors.left: txtType1Num.right
            anchors.verticalCenter: imageType1.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true

            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: "=  "  + totalBales
        }

        Text {
            id: txtType2Total
            anchors.left: txtType2Num.right
            anchors.verticalCenter: imageType2.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true

            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: "=  " + totalPlanks
        }

        Text {
            id: txtType3Total
            anchors.left: txtType3Num.right
            anchors.verticalCenter: imageType3.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true
            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: "=  " + totalBricks
        }

        Text {
            id: txtTimeBonus
            anchors.left: txtTimeTaken.right
            anchors.verticalCenter: txtTimeTaken.verticalCenter
            anchors.leftMargin: 20

            font.pixelSize: 30
            font.bold: true
            style: Text.Outline
            styleColor: "black"
            color: "white"

            text: "=  " + timeBonus
        }


    }

    function showBoard() {
        state = "VISIBLE";
    }

    function hideBoard() {
        state = "HIDDEN"
    }

    function calculateTotals() {
        totalBales = numBales * 10;
        totalPlanks = numPlanks * 20;
        totalBricks = numBricks * 30;

        timeBonus = (60/timeTaken) * (totalBales + totalPlanks + totalBricks);
    }

    states: [
        State {
            name: "HIDDEN"
            PropertyChanges { target: levelScoreBoard; opacity: 0}
        },
        State {
            name: "VISIBLE"
            PropertyChanges { target: levelScoreBoard; opacity: 1}
        }
    ]

    transitions: Transition {
        NumberAnimation { properties: "opacity"; easing.type: Easing.Linear; duration: 600 }
    }

}
