import QtQuick 1.0
import "sizer.js" as Sizer;

Item {
    property real xspeed;
    property real yspeed;
    property bool moving;

    width: chickimage.width
    height: chickimage.height
    transform: Rotation { origin.x: width/2; origin.y: height/2; angle: x}

    Image {
        id: chickimage
        source: "pics/chick.svg"
        width: Sizer.chickSize()
        height: Sizer.chickSize()
        fillMode: Image.PreserveAspectFit
        smooth: true
    }

    function reset() {
        x = (thepaddle.x + thepaddle.width / 2) - width/2;
        y = thepaddle.y - height;
        xspeed = -8;
        yspeed = -8;
    }

}
