#include "Loader.h"
#include <QFile>
#include <QDebug>
#include <QCoreApplication>
#include <QFileInfo>

Loader::Loader(QObject *parent) :
    QObject(parent)
{
}

QString Loader::loadLevel(const QString &levelPack, int level)
{
    QString levelFilePath = QString("qml/pgz-farmbreakout/levels/%1/level%2.dat").arg(levelPack).arg(level);
    levelFilePath = adjustPath(levelFilePath);

    QFile levelFile(levelFilePath);

    QString data;
    if (levelFile.open(QIODevice::ReadOnly | QIODevice::Text)) {
        data = levelFile.readAll();

        levelFile.close();
    } else {
        qDebug() << "Unable to read " << levelFilePath;
    }
    return data;
}

bool Loader::levelExists(const QString &levelPack, int level)
{
    QString levelFilePath = QString("qml/pgz-farmbreakout/levels/%1/level%2.dat").arg(levelPack).arg(level);
    levelFilePath = adjustPath(levelFilePath);

    QFile levelFile(levelFilePath);

    if (!levelFile.exists()) {
        qDebug() << levelFilePath <<  "does not exist";
    }

    return levelFile.exists();
}

QString Loader::adjustPath(const QString &path)
{
#ifdef Q_OS_UNIX
#ifdef Q_OS_MAC
    if (!QDir::isAbsolutePath(path))
        return QCoreApplication::applicationDirPath()
                + QLatin1String("/../Resources/") + path;
#else
    const QString pathInInstallDir = QCoreApplication::applicationDirPath()
        + QLatin1String("/../") + path;
    if (pathInInstallDir.contains(QLatin1String("opt"))
            && pathInInstallDir.contains(QLatin1String("bin"))
            && QFileInfo(pathInInstallDir).exists()) {
        return pathInInstallDir;
    }
#endif
#endif
    return path;
}
