#include "trailtrip.h"
#include <qdebug.h>

TrailTrip::TrailTrip(const QDomElement& trip)
{
    m_id = trip.attribute("id", "-1").toLong();

    for (int i = 0; i < trip.childNodes().count(); ++i)
    {
        QDomElement node = trip.childNodes().at(i).toElement();
        qDebug() << i << node.nodeName() << node.text();
        if (node.nodeName() == "name")
        {
            m_name = node.text();
        }
        else if (node.nodeName() == "user")
        {
            m_userName = node.text();
            m_userId = node.attribute("id", "-1").toInt();
        }
        else if (node.nodeName() == "activity")
        {
            m_activity = node.text();
        }
        else if (node.nodeName() == "description")
        {
            m_description = node.text();
        }
        else if (node.nodeName() == "tips")
        {
            m_tips = node.text();
        }
        else if (node.nodeName() == "date")
        {
            m_date = QDate::fromString(node.text(), "yyyy-MM-dd");
        }
        else if (node.nodeName() == "location")
        {
            m_location = node.text();
        }
        else if (node.nodeName() == "gpx")
        {
            m_gpx = node.text();
        }
        else if (node.nodeName() == "kml")
        {
            m_kml = node.text();
        }
        else if (node.nodeName() == "length")
        {
            m_length = node.text().toFloat();
        }
        else if (node.nodeName() == "duration")
        {
            m_duration = node.text().toFloat();
        }
        else if (node.nodeName() == "pictures")
        {
            qDebug() << node.childNodes().count() << " pictures";
            for (int j = 0; j < node.childNodes().count(); ++j)
            {
                QDomElement pic = node.childNodes().at(j).toElement();
                qDebug() << j << pic.nodeName() << pic.text();
                m_pictures << new TrailPicture(pic);
            }
        }
    }
}

int TrailTrip::pictureCount() const
{
    return m_pictures.count();
}

QString TrailTrip::pictureThumbnail(int i) const
{
    return m_pictures[i]->thumbnail();
}

TrailPicture::TrailPicture(const QDomElement &pic)
{
    m_id = pic.attribute("id", 0).toInt();
    m_thumbnail = pic.firstChild().toElement().text();
    qDebug() << m_thumbnail;
}

QString TrailPicture::thumbnail() const
{
    return m_thumbnail;
}
