#include "traillogin.h"

#include <qboxlayout.h>
#include <QLineEdit>
#include <QPushButton>
#include <QLabel>
#include "trailinterface.h"
#include <QDebug>
#include <QMessageBox>
#include <QtGlobal>
#include <QCheckBox>
#include <QSettings>

TrailLogin::TrailLogin(TrailInterface* interface, QWidget *parent) :
    QWidget(parent)
{
    m_interface = interface;
    m_layout = new QVBoxLayout();
    m_btnLayout = new QHBoxLayout();
    m_user = new QLineEdit(this);
    m_pass = new QLineEdit(this);
    m_remember = new QCheckBox(this);

    m_remember->setText(tr("Remember"));
//Dont set the echo mode on the phone as its screwed up atm
#ifdef Q_OS_SYMBIAN
    m_pass->setEchoMode(QLineEdit::Normal);
#else
    m_pass->setEchoMode(QLineEdit::Password);
#endif

    m_loginButton = new QPushButton("Login");
#ifdef Q_OS_SYMBIAN
    forceButtonColor(m_loginButton, Qt::black);
#endif

    m_dontLoginButton = new QPushButton("Dont Login");

    m_layout->addWidget(new QLabel("Username"));
    m_layout->addWidget(m_user);

    m_layout->addWidget(new QLabel("Password"));
    m_layout->addWidget(m_pass);

    m_btnLayout->addWidget(m_loginButton);
    m_btnLayout->addWidget(m_remember);
    m_layout->addLayout(m_btnLayout);

    m_layout->addWidget(m_dontLoginButton);

    m_layout->addStretch();

    setLayout(m_layout);

    QSettings settings;

    if (settings.value("login/remember").toBool()) {
        m_remember->setChecked(true);
        m_user->setText(settings.value("login/username").toString());
        m_pass->setText(settings.value("login/password").toString());

        slotLoginClicked();
    }

    connect(m_loginButton, SIGNAL(clicked()), this, SLOT(slotLoginClicked()));
    connect(m_interface, SIGNAL(loginComplete(long)), this, SLOT(slotLoginReceived(long)));
    connect(m_dontLoginButton, SIGNAL(clicked()), this, SLOT(slotDontLogin()));
}

void TrailLogin::slotLoginClicked()
{
    QSettings settings;
    settings.setValue("login/remember", m_remember->isChecked());

    if (m_remember->isChecked()) {
        settings.setValue("login/username", m_user->text());
        settings.setValue("login/password", m_pass->text());
    } else {
        settings.setValue("login/usernmae", QString());
        settings.setValue("login/password", QString());
    }

    m_interface->login(m_user->text(), m_pass->text());
}

void TrailLogin::slotLoginReceived(long id)
{
    qDebug() << id;
    if (id > 0)
    {
        emit(loggedIn());
    }
    else
    {
        QMessageBox::information(this, "Login Failed", QString("Login Failed %1").arg(id));
    }
}

void TrailLogin::slotDontLogin()
{
    emit(loggedIn());
}
