/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "pppaper.h"
#include <QtCore>
#include "ppxmlpaper.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QGraphicsScene * scene = new QGraphicsScene(this);
    ui->view->setScene(scene);

    pencilBox = new PPPencilBox();
    scene->addItem(pencilBox);

    paper = new PPPaper();
    scene->addItem(paper);

    paper->setRect(QRect(-10,0,200,200));

    PPBackground bg;
    QPixmap pixmap(50,50);
    pixmap.fill(Qt::white);

    QPainter painter(&pixmap);
    QPen pen(Qt::red);
    painter.setPen(pen);
    painter.drawLine(0,0,0,49);

    pen.setColor(Qt::blue);
    painter.setPen(pen);
    painter.drawLine(0,49,49,49);

    painter.end();
    bg.setPixmap(pixmap);
    bg.setRepeatX(true);
    bg.setRepeatY(true);
    bg.setColor(Qt::black);

    paper->setBackground(bg);

    pencilBox->setPaper(paper);

    QGraphicsRectItem *rectItem = new QGraphicsRectItem();
    rectItem->setRect(1,1,48,48);
    pen.setColor(Qt::green);
    rectItem->setPen(pen);

    scene->addItem(rectItem);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void MainWindow::on_penButton_clicked(bool checked)
{
    qDebug() << __func__;
    if (checked) {

        pencilBox->setTool(PPPencilBox::Pen);
        ui->eraserButton->setChecked(false);

    } else {
        if (pencilBox->tool() == PPPencilBox::Pen) {
            pencilBox->setTool(PPPencilBox::None);
        }
    }
}

void MainWindow::on_eraserButton_clicked(bool checked)
{
    qDebug() << __func__;
    if (checked) {

        pencilBox->setTool(PPPencilBox::Eraser);
        ui->penButton->setChecked(false);

    } else {
        if (pencilBox->tool() == PPPencilBox::Eraser) {
            pencilBox->setTool(PPPencilBox::None);
        }
    }
}

void MainWindow::on_clearButton_clicked()
{
    paper->clear();
}
