#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "maemo5paperbackgrounddialog.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QList<QAction*> actions = ui->drawpad->actions();
    ui->toolBar->addActions(actions);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

Drawpad* MainWindow::drawpad(){
    return ui->drawpad;
}

void MainWindow::on_actionBackground_triggered()
{
    Maemo5PaperBackgroundDialog dialog;

    PPPaperBackground bg = ui->drawpad->paper()->background();

    dialog.setColor(bg.color());
    if (dialog.exec() == QDialog::Accepted ) {
        bg = dialog.selectBackground();
        ui->drawpad->paper()->setBackground(bg);
        ui->drawpad->refresh();
    }
}
