#ifndef PAGEEDITORWINDOW_H
#define PAGEEDITORWINDOW_H

#include <QMainWindow>

#include "pageentity.h"
#include "drawpad.h"
#include "page.h"
#include "ppbackground.h"

namespace Ui {
    class PageEditorWindow;
}

class PageEditorWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PageEditorWindow(QWidget *parent = 0);
    ~PageEditorWindow();

    void newPage(int bookId);
    bool open(int pageId = -1);
    bool save();

    void clear();

    void setViewportSize(QSize val);

    Drawpad* drawpad();

    void setDefaultBackground(PPBackground val);
    PPBackground lastSelectedBackground();

signals:
    void saved(int pageId);
    void deleted(int pageId);

protected:
    void changeEvent(QEvent *e);
    virtual void closeEvent ( QCloseEvent * event );
    virtual void showEvent(QShowEvent *event);
    virtual void keyPressEvent(QKeyEvent* event);

private:
    void setMenuVisible(bool val);
    void setCenter();
    void zoom(qreal factor);
    void zoomNormal();

    Ui::PageEditorWindow *ui;
    StandardPage *m_page;

    /// The last selected background color
    PPBackground m_background;

    /// The expected viewport size of QGraphicsView object
    /**
      @remarks It may be different the real size if ui->view
     */
    QSize viewportSize;

    /// Truth if the draw is zoomed
    bool zooming;

private slots:
    void on_actionFullScreen_triggered();
    void on_actionBackground_triggered();
    void on_actionExport_triggered();
    void on_actionDelete_triggered();
    void onModeChanged();
};

#endif // PAGEEDITORWINDOW_H
