#ifndef SKETCHPAPER_H
#define SKETCHPAPER_H

#include <QObject>
#include <QSize>
#include <QGraphicsItem>
#include <QDomDocument>
#include <QGraphicsObject>
#include "ppbackground.h"
#include "pppaper.h"

/// Basic sketch page

class SketchPaper : public PPPaper {
public:
    explicit SketchPaper(QGraphicsItem * parent = 0);
    ~SketchPaper();

    virtual QRectF boundingRect() const;
    virtual void clear();

    /*
    virtual bool setFromElement(QDomElement &element);
    virtual QDomElement createElement(QDomDocument &doc);
    */

    virtual void snapshot(QPainter * painter, QRectF &target);

    bool isResizable();
    void setResizable(bool val);

private:
    bool m_resizable;

};

#endif // PAPER_H
