/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QPainter>
#include <QtCore>
#include "ppbackgroundmodel.h"

PPBackgroundModel::PPBackgroundModel(QObject *parent) :
    QAbstractItemModel(parent)
{
    m_thumbnailSize = QSize(120,120);
    m_paperSize = QSize(400,400);
    m_searchingPath << ".";
}

int PPBackgroundModel::rowCount(const QModelIndex &parent) const{
    int ret;
    if (parent.column() > 0) {
        ret = 0;
    } else {
        ret = storage.size();
    }

    return ret;
}

int PPBackgroundModel::columnCount(const QModelIndex &parent) const{
    int ret = 1;
    if (parent.column() > 0)
        ret = 0;

//	qDebug() << __func__  << ret;
    return ret;

}

QModelIndex PPBackgroundModel::index(int row, int column, const QModelIndex &parent) const{
//	qDebug() << __func__ << row << column;
    if (parent.isValid()) // Nested is not supported
        return QModelIndex();
    return createIndex(row,column);
}

QVariant PPBackgroundModel::data(const QModelIndex &index, int role) const{
    QVariant v;

    if (index.column() == 0 && index.row() < storage.size() ){

        if (role == Qt::DisplayRole || role == Qt::EditRole) {
            PPBackgroundModelPriv priv = storage.at(index.row());
            v = priv.name;
        } else if (role == Qt::DecorationRole) {
            PPBackgroundModelPriv priv = storage.at(index.row());

            QPixmap pixmap(m_paperSize);
            pixmap.fill(Qt::white);
            QRect rect(0,0,m_paperSize.width(),m_paperSize.height());

            QPainter painter(&pixmap);
            priv.bg.paint(&painter,rect);
            painter.end();

            pixmap = pixmap.scaled(m_thumbnailSize,Qt::KeepAspectRatio,Qt::SmoothTransformation);
            v = pixmap;
        }

    }

    return v;
}

QVariant PPBackgroundModel::headerData(int section, Qt::Orientation orientation, int role) const{
    QVariant header;
    if (orientation == Qt::Horizontal) {
        if (role == Qt::DisplayRole) {
            switch (section) {
                case 0:
                    header = tr("Name");
                    break;
            }
        }
    } else {
        header = QAbstractItemModel::headerData(section, orientation, role);
    }

    return header;
}

QModelIndex PPBackgroundModel::parent ( const QModelIndex & index ) const{
    Q_UNUSED(index);
    return QModelIndex();
}

Qt::ItemFlags PPBackgroundModel::flags ( const QModelIndex & index ) const{
    if (index.isValid())
         return Qt::ItemIsDragEnabled | Qt::ItemIsDropEnabled | Qt::ItemIsSelectable | Qt::ItemIsEnabled;
    return Qt::NoItemFlags	;
}

void PPBackgroundModel::append(PPBackground bg , QString name){
    PPBackgroundModelPriv priv;
    priv.name = name;
    priv.bg = bg;
    storage.append(priv);

    emit layoutChanged();
}

void PPBackgroundModel::append(PPBackground bg, QString name , QString file){

    foreach (QString path ,m_searchingPath) {
        QString filename = path + "/" + file;
        QFileInfo info (filename);

        if (info.exists()) {
            qDebug() << "Found" << filename;
            QPixmap pixmap;
            if (pixmap.load(filename)) {
                QUrl url = QUrl::fromLocalFile(filename);
                bg.setSrc(url);
                bg.setPixmap(pixmap);
                break;
            }
        }
    }

    append(bg,name);
}

void PPBackgroundModel::addSearchingPath(QString path){
    m_searchingPath << path;
}


void PPBackgroundModel::setThumbnailSize(QSize size){
    m_thumbnailSize = size;
}

PPBackground PPBackgroundModel::backgroundAt(int index){
    PPBackground bg;
    if (index >=0 && index < storage.size()) {
        PPBackgroundModelPriv priv = storage.at(index);
        bg = priv.bg;
    }
    return bg;
}
