/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QPalette>
#include <QtCore>
#include <QPainter>
#include <QFileDialog>
#include <QDesktopServices>

#include "maemo5paperbackgrounddialog.h"
#include "ui_maemo5paperbackgrounddialog.h"
#include "maemo5colordialog.h"
#include "ppbackgroundmodeldialog.h"
Maemo5PaperBackgroundDialog::Maemo5PaperBackgroundDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Maemo5PaperBackgroundDialog)
{
    ui->setupUi(this);

    connect(ui->colorButton,SIGNAL(clicked()),
            this,SLOT(selectColor()));
    connect(ui->selectColorButton,SIGNAL(clicked()),
            this,SLOT(selectColor()));

    ui->preview->installEventFilter(this);
    background.setColor(Qt::white);
    refresh();
}

Maemo5PaperBackgroundDialog::~Maemo5PaperBackgroundDialog()
{
    delete ui;
}

void Maemo5PaperBackgroundDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


bool Maemo5PaperBackgroundDialog::eventFilter(QObject *watched, QEvent *event){

    if (watched == ui->preview
        && event->type() == QEvent::MouseButtonPress ){
        loadTemplate();
    }
    return QDialog::eventFilter(watched,event);
}


void Maemo5PaperBackgroundDialog::setDefaultBackground(PPBackground val){
    background = val;
    refresh();
}

PPBackground Maemo5PaperBackgroundDialog::selectedBackground(){
    return background;
}

void Maemo5PaperBackgroundDialog::refresh(){
    QString style = "border : 2px solid white; background: rgb(%1,%2,%3)";
    QColor color = background.color();
    style = style.arg(color.red()).arg(color.green()).arg(color.blue());
    ui->colorButton->setStyleSheet(style);

    QPixmap pixmap(400,400);
    QRect rect(0,0,400,400);

    QPainter painter(&pixmap);
    background.paint(&painter,rect);
    painter.end();

    pixmap = pixmap.scaled(QSize(120,120),Qt::KeepAspectRatio,
                           Qt::SmoothTransformation);

    ui->preview->setPixmap(pixmap);
}

void Maemo5PaperBackgroundDialog::selectColor(){
    Maemo5ColorDialog dialog;
    dialog.setCurrentColor(background.color());

    if (dialog.exec() == QDialog::Accepted ){
        background.setColor(dialog.selectedColor());
        refresh();
    }
}

void Maemo5PaperBackgroundDialog::on_confirmButton_clicked()
{
    accept();
}


void Maemo5PaperBackgroundDialog::on_databaseButton_clicked()
{
    loadTemplate();
}

void Maemo5PaperBackgroundDialog::loadTemplate(){
    PPBackground bg;

    PPBackgroundModelDialog dialog;
    dialog.model()->addSearchingPath("/opt/maemo/usr/share/penpen/backgrounds");

    bg = PPBackground();
    bg.setColor(Qt::white);
    bg.setRepeatX(true);
    bg.setRepeatY(true);
    dialog.model()->append(bg,"Lines","lines.png");

    bg = PPBackground();
    bg.setColor(Qt::white);
    bg.setRepeatX(false);
    bg.setRepeatY(true);
    dialog.model()->append(bg,"Check List","checklist.png");

    bg = PPBackground();
    bg.setColor(Qt::white);
    bg.setRepeatX(true);
    bg.setRepeatY(true);
    dialog.model()->append(bg,"Grid","grid.png");


    if (dialog.exec() == QDialog::Accepted)  {
        bg = dialog.selectedBackground();
        if (!bg.isNull()) {
            background = bg;
            refresh();
        }
    }

}

void Maemo5PaperBackgroundDialog::on_clearButton_clicked()
{
    background = PPBackground();
    background.setColor(Qt::white);

    refresh();
}

void Maemo5PaperBackgroundDialog::on_filesButton_clicked()
{
    QString fileName = QFileDialog::getOpenFileName(0,
                                                    QString("Select Background"),
                                                    QDesktopServices::storageLocation(QDesktopServices::PicturesLocation),
                                             tr("Images (*.png *.jpg)"));
    if (!fileName.isNull()){
        background.setSrc(QUrl::fromLocalFile(fileName));
        background.setRepeatX(true);
        background.setRepeatY(true);
        background.load();
        refresh();
    }
}
