#include "pageviewerwindow.h"
#include "ui_pageviewerwindow.h"

PageViewerWindow::PageViewerWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::PageViewerWindow)
{
    ui->setupUi(this);

    m_model = new PageModel(this);

    ui->listView->setModel(m_model);

}

PageViewerWindow::~PageViewerWindow()
{
    delete ui;
}

void PageViewerWindow::open(int bookId){
    m_model->open(bookId);

    ui->listView->scrollTo(m_model->index(m_model->rowCount() -1 ,0));
}

void PageViewerWindow::append(int bookId){
    m_model->append(bookId);
}

PageModel *PageViewerWindow::model(){
    return m_model;
}

void PageViewerWindow::setThumbnailSize(QSize thumbnail){
    int margin = 5;
    QSize grid( thumbnail.width() + margin * 2 , thumbnail.height() + margin * 2);

    ui->listView->setGridSize(grid);
    m_model->setThumbnailSize(thumbnail);
    m_model->refresh();
}

void PageViewerWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void PageViewerWindow::on_addNewPageButton_clicked()
{
    emit requestNewPage();
}

void PageViewerWindow::on_listView_activated(QModelIndex index)
{
    QVariant v = ui->listView->model()->data(index,PageModel::PageIdRole);

    emit requestOpenPage(v.toInt());
}
