#ifndef STROKERECORDER_H
#define STROKERECORDER_H

#include <QGraphicsObject>
#include "graphicsstroke.h"
/// Record and create stroke
class StrokeRecorder : public QGraphicsObject
{
    Q_OBJECT
public:
    explicit StrokeRecorder(QGraphicsItem *parent = 0);

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 )  ;
    virtual QRectF boundingRect() const;

    /// Capture and start draw on canvas
    void record(QGraphicsItem* canvas);

    /// Stop the capture. It won't emit captured signal
    void stop();

    void setPen(QPen &pen);
    QPen pen();

signals:
    void recorded();

public slots:

protected:
    virtual bool sceneEventFilter ( QGraphicsItem * watched, QEvent * event);

private:
    QGraphicsItem *canvas;
    QPen m_pen;

    GraphicsStroke *stroke;
};

#endif // STROKERECORDER_H
