#ifndef PAGEVIEWERWINDOW_H
#define PAGEVIEWERWINDOW_H

#include <QMainWindow>
#include "pagemodel.h"

namespace Ui {
    class PageViewerWindow;
}

class PageViewerWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PageViewerWindow(QWidget *parent = 0);
    ~PageViewerWindow();

    void open(int bookId);
    void append(int bookId);
    PageModel *model();
    void setThumbnailSize(QSize thumbnail);

signals:
    /// The signal is emitted when "Add new page" is pressed
    void requestNewPage();

    void requestOpenPage(int pageId);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::PageViewerWindow *ui;
    PageModel *m_model;

private slots:
    void on_listView_activated(QModelIndex index);
    void on_addNewPageButton_clicked();
};

#endif // PAGEVIEWERWINDOW_H
