#include <QtCore>
#include <QApplication>
#include <QDesktopWidget>

#include "maemo5application.h"
#include "tables.h"
#include "pageeditorwindow.h"

Maemo5Application::Maemo5Application(QObject *parent) :
    QObject(parent)
{
    viewer = new PageViewerWindow();
    bookId = 1;
    connect(viewer,SIGNAL(requestNewPage()),
            this,SLOT(newPage()));
    connect(viewer,SIGNAL(requestOpenPage(int)),
            this,SLOT(openPage(int)));



#ifdef Q_WS_MAEMO_5
    viewer->setAttribute(Qt::WA_Maemo5StackedWindow);
    viewer->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    viewer->setWindowFlags(viewer->windowFlags() | Qt::Window);

    editor = new PageEditorWindow(viewer);
    editor->setAttribute(Qt::WA_Maemo5StackedWindow);
    editor->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    editor->setWindowFlags(editor->windowFlags() | Qt::Window);

    connect(QApplication::desktop(), SIGNAL(resized(int)),
            this, SLOT(setWinSize()));
#else
    editor = new PageEditorWindow();
#endif

    connect(editor,SIGNAL(saved(int)),
            this,SLOT(onPageSaved(int)));
    connect(editor,SIGNAL(deleted(int)),
            this,SLOT(onPageDeleted(int)));

    setWinSize();
}

int Maemo5Application::exec(){
    Storage *storage = Storage::instance();
    storage->open();

    BookEntity entity;
    if (!entity.load(storage,bookId)){ // Load default book
        entity.setId(bookId);
        entity.save(storage);// Create if it is missed.
    }

    viewer->show();
    viewer->open(bookId);

    setWinSize();

    return qApp->exec();
}

void Maemo5Application::newPage(){

    editor->newPage(bookId);
    editor->show();

}

void Maemo5Application::openPage(int pageId){


    editor->open(pageId);
    editor->show();

}


void Maemo5Application::onPageSaved(int pageId){
    viewer->append(pageId);
}

void Maemo5Application::onPageDeleted(int pageId){
    viewer->model()->remove(pageId);
}

void Maemo5Application::setWinSize(){
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    QSize thumbnail;
    QSize viewport;
    if (screenGeometry.width() > screenGeometry.height()) {
        thumbnail = QSize(180,80);
        viewport = QSize(800,480 - 130);
    } else {
        thumbnail = QSize(128,180);
        viewport = QSize(480,800 - 130);
    }

    viewer->setThumbnailSize(thumbnail);
    editor->setViewportSize(viewport);

}
