# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import copy

ItemWidth = 400
ItemHeight = 80
HeaderHeight = 36
CheckWidth = 80

class ItemDelegate(QStyledItemDelegate):
    def __init__(self, ds, parent=None, *args):
        QStyledItemDelegate.__init__(self, parent, *args)
        self.ds = ds
        if parent is not None:
            opt = QStyleOptionButton()
            opt.initFrom(parent)
            checksize = parent.style().subElementRect(QStyle.SE_CheckBoxIndicator, opt)
            self.checkw = checksize.width()
            self.checkh = checksize.height()

    def paint(self, painter, option, index):
        value = index.data(Qt.DisplayRole)
        if not value.isValid():
            return
        task = value.toPyObject()
        showProjectHeader = self.prevProjectNum(index) != task.projectnum

        painter.save()
        r = option.rect
        f = painter.font()

        if showProjectHeader:
            header_r = copy.copy(r)
            header_r.setBottom(header_r.top()+HeaderHeight)
            r.setTop(r.top()+HeaderHeight)
            painter.fillRect(header_r, Qt.darkBlue)
            f.setBold(True)
            painter.setFont(f)
            painter.drawText(header_r.left()+2, header_r.top(), header_r.width(), header_r.height(), Qt.AlignTop|Qt.AlignLeft, self.ds.getProject(task.projectnum))

        gradientBase = QLinearGradient(QPointF(r.topLeft()), QPointF(r.bottomLeft()))
        base = option.palette.color(QPalette.Window)
        base2 = copy.copy(base)
        if task.overdue():
            base.setRgb(min(255, base.red()+128), min(255, base.green()+64), min(255, base.blue()+64))
            base2.setRgb(max(0, base2.red()+64), max(0, base2.green()-20), max(0, base2.blue()-20))
        else:
            base.setRgb(min(255, base.red()+64), min(255, base.green()+64), min(255, base.blue()+64))
            base2.setRgb(max(0, base2.red()-20), max(0, base2.green()-20), max(0, base2.blue()-20))
        gradientBase.setColorAt(0, base)
        gradientBase.setColorAt(1, base2)
        painter.fillRect(r, QBrush(gradientBase))
        painter.drawLine(QPoint(r.left(), r.bottom()), QPoint(r.right(), r.bottom()))
        cboption = QStyleOptionButton()
        cboption.initFrom(self.parent())
        cboption.rect = QRect(r)
        cboption.rect.setWidth(self.checkw)
        cboption.rect.setHeight(self.checkh)
        if task.completed is not None:
            cboption.state = QStyle.State_On
        else:
            cboption.state = QStyle.State_Off
        self.parent().style().drawPrimitive(QStyle.PE_IndicatorCheckBox, cboption, painter)
        r.setLeft(r.left()+CheckWidth)
        f.setBold(False)
        painter.setFont(f)
        painter.drawText(r.left()+2, r.top(), r.width(), r.height(), Qt.AlignTop|Qt.AlignLeft, task.desc)
        f.setPointSize(f.pointSize()-4)
        painter.setFont(f)
        datestring=''
        if task.due is not None:
            datestring += "Due: "+str(task.due.date())
        if task.start is not None:
            if datestring != '':
                datestring += ", "
            datestring += "Start: "+str(task.start.date())
        if datestring != '':
            if task.overdue():
                painter.setPen(Qt.red)
            else:
                painter.setPen(Qt.darkRed)
            painter.drawText(r.left()+2, r.top(), r.width()-4, r.height()-2, Qt.AlignBottom|Qt.AlignLeft, datestring)
        painter.setPen(Qt.cyan)
        painter.drawText(r.left()+2, r.top(), r.width()-4, r.height()-2, Qt.AlignBottom|Qt.AlignRight, task.tags)

        painter.restore()

    def sizeHint(self, style, index):
        if not index.isValid():
            return QSize(10, 10) # index should be valid, right?
        # first item always has a project header
        if index.row() == 0:
            return QSize(ItemWidth, ItemHeight+HeaderHeight)
        # see if previous item was in a different project, and therefore this
        # one needs a header
        if self.prevProjectNum(index) != \
                index.data(Qt.DisplayRole).toPyObject().projectnum:
            return QSize(ItemWidth, ItemHeight+HeaderHeight)
        else:
            return QSize(ItemWidth, ItemHeight)

    def prevProjectNum(self, index):
        previndex = index.model().createIndex(index.row()-1, 0)
        if previndex.isValid():
            data = previndex.data(Qt.DisplayRole)
            if data is not None:
                return data.toPyObject().projectnum
        return None

